import xbmcgui
import xbmcaddon

class ShowCorrectAnswerDialog(xbmcgui.WindowXMLDialog):
    """Dialog pro přepínač zobrazení správné odpovědi."""
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.addon = xbmcaddon.Addon()
        self.dialog_closed = False
        self.title_text = 'Testovací nadpis z Pythonu'

    def onInit(self):
        # Nastavím nadpis z Pythonu
        try:
            self.getControl(7205).setLabel(self.title_text)
        except Exception as e:
            import xbmc
            xbmc.log(f"ShowCorrectAnswerDialog: Nelze nastavit nadpis: {e}", xbmc.LOGERROR)
        # Přečtu hodnotu z nastavení jako string
        value_str = self.addon.getSetting('millionaire_show_correct_answer')
        try:
            self.getControl(7206).setLabel(f"Toto je hodnota z nastavení: {value_str}")
        except Exception as e:
            import xbmc
            xbmc.log(f"ShowCorrectAnswerDialog: Nelze nastavit hodnotu z nastavení: {e}", xbmc.LOGERROR)
        value = self.addon.getSettingBool('millionaire_show_correct_answer')
        self.getControl(7201).setSelected(value)
        self._update_status_label(value)

    def onClick(self, controlId):
        if controlId == 7201:
            btn = self.getControl(7201)
            new_value = not btn.isSelected()
            btn.setSelected(new_value)
            self.addon.setSettingBool('millionaire_show_correct_answer', new_value)
            self._update_status_label(new_value)
        elif controlId == 7202:
            self.dialog_closed = True
            self.close()

    def onAction(self, action):
        import xbmcgui
        if action.getId() in [xbmcgui.ACTION_NAV_BACK, xbmcgui.ACTION_PREVIOUS_MENU]:
            self.dialog_closed = True
            self.close()

    def _update_status_label(self, value):
        label = "Zobrazit správnou odpověď: Zapnuto" if value else "Zobrazit správnou odpověď: Vypnuto"
        try:
            self.getControl(7203).setLabel(label)
        except:
            pass


def show_show_correct_answer_dialog():
    addon = xbmcaddon.Addon()
    dialog = ShowCorrectAnswerDialog(
        'games/DialogShowCorrectAnswer.xml',
        addon.getAddonInfo('path'),
        'Default',
        '1080i'
    )
    dialog.doModal()
    del dialog 