# Milionář – Prompty pro typ Herec (kopírovatelné do kódu)

Níže jsou finální, samostatné prompty pro typ hry Herec. Každý prompt je nezávislý inference call, respektuje globální obtížnost `{difficulty_header}` a má jednotný JSON výstup. Bloky lze přímo vložit do funkcí v `wcs/ai_handler.py`.

---

## SNADNÁ (Herec)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 SNADNÉ otázky pro kvíz typu "Chcete být milionářem" o herci {actor_name}.{bio_info}{roles_info}

OBTÍŽNOST: SNADNÁ - "Základní znalosti kariéry"
TÉMATA: Narození, nejslavnější role, základní ocenění, kariérní fakta
CÍLOVÁ SKUPINA: Každý fanoušek filmů pozná

PŘÍKLADY TÉMAT:
- Kdy se herec narodil?
- Ve kterém filmu hrál hlavní roli?
- Za jaký film získal Oscar?
- Jaké je jeho nejslavnější dílo?
- V jakém roce debutoval v kině?
- Jaké je jeho rodné město?
- Který film ho proslavil?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být JEDNODUCHÉ pro běžného fanouška
- Zaměř se POUZE na základní fakta a nejslavnější díla
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## STŘEDNÍ (Herec)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 STŘEDNÍ otázky pro kvíz typu "Chcete být milionářem" o herci {actor_name}.{bio_info}{roles_info}

OBTÍŽNOST: STŘEDNÍ - "Pozornost k detailům kariéry"
TÉMATA: Konkrétní role, spolupráce s dalšími osobnostmi, méně známá díla, citované výroky
CÍLOVÁ SKUPINA: Pozorný fanoušek si všimne

PŘÍKLADY TÉMAT:
- Jakou roli hrál v [konkrétním filmu]?
- S kým spolupracoval v [rok]?
- Jaký slavný výrok pronesl?
- V kterém méně známém filmu hrál?
- Jakou postavu ztvárnil v [seriálu]?
- S jakým režisérem spolupracoval?
- Jaké má herecké vzdělání?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být STŘEDNÍ obtížnosti
- Zaměř se na DETAILY kariéry a spolupráce
- Vyžadují lepší znalost herce, ne jen základní fakta
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## TĚŽKÁ (Herec)

```python
prompt = f"""{difficulty_header}Jsi filmový historik. Vytvoř přesně 3 TĚŽKÉ otázky pro kvíz typu "Chcete být milionářem" o herci {actor_name}.{bio_info}{roles_info}

OBTÍŽNOST: TĚŽKÁ - "Herecká erudice"
TÉMATA: Detailní trivia, specifická ocenění, méně známé projekty, historické souvislosti
CÍLOVÁ SKUPINA: Skutečný znalec herce pozná

PŘÍKLADY TÉMAT:
- Za jakou roli byl nominován na [konkrétní rok]?
- V kterém divadelním představení hrál?
- Jaké má konkrétní ocenění z [festival]?
- V jakém roce debutoval v televizi?
- Jaké má vzdělání v herectví?
- Který méně známý film režíroval?
- Jaké má konkrétní hobby nebo zájmy?
- V kterém roce získal [konkrétní cenu]?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být TĚŽKÉ - pro skutečné znalce
- Zaměř se na DETAILNÍ TRIVIA a méně známé fakta
- Kombinace znalosti herce + filmové kultury
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```