#!/usr/bin/python
# -*- coding: utf-8 -*-

import xbmc
import xbmcaddon
import time
import datetime

# Všechny ne-credential settings a jejich výchozí hodnoty
# Formát: (setting_id, default_value)
DEFAULT_SETTINGS = [
    # Hlavní nastavení
    ('default_movie_action', '1'),
    ('show_episode_info', 'true'),
    ('dialog_style', '0'),
    ('autoplay_first_item', 'false'),
    ('autoplay_preferred_quality', '0'),
    ('auto_start_enabled', 'false'),
    ('auto_start_action', '1'),
    ('auto_start_show_notifications', 'true'),
    ('auto_start_delay_seconds', '1'),
    # Menu položky
    ('menu_show_mytv', 'true'),
    ('menu_show_mycinema', 'true'),
    ('menu_show_ai_chat', 'false'),
    ('menu_show_continue_watching', 'false'),
    ('menu_show_recently_played', 'false'),
    ('menu_show_my_collection', 'false'),
    ('menu_show_favorite_actors', 'false'),
    ('menu_show_favorite_directors', 'false'),
    ('menu_show_favorite_writers', 'false'),
    ('menu_show_ai_stats', 'false'),
    # MyTV
    ('mytv_upcoming_count', '12'),
    ('mytv_block_size', '2'),
    ('mytv_channel_naming', 'Automaticky podle žánru'),
    ('mytv_background_mode', 'Fanart seriálu'),
    ('mytv_background_blur', 'false'),
    ('mytv_background_blur_radius', '5'),
    ('mytv_background_glow', 'false'),
    ('mytv_background_glow_intensity', '3'),
    ('mytv_background_dim', '50'),
    ('mytv_background_animation', 'false'),
    ('mytv_anim_style', 'Jemny dech'),
    ('mytv_design', '2'),
    ('mytv_play_selection_style', 'Modal Card'),
    # Milionář
    ('millionaire_difficulty', '1'),
    ('millionaire_show_correct_answer', 'false'),
    ('millionaire_highlight_delay', '30'),
    ('milionar_len_welcome', '2'),
    ('milionar_len_intro', '1'),
    ('milionar_len_result', '2'),
    ('milionar_len_transition', '1'),
    ('milionar_len_explanation', '1'),
    ('milionar_moderator_style', '2'),
    ('milionar_autoplay', 'false'),
    ('milionar_autoplay_fail_round', '0'),
    ('milionar_autoplay_speed', '5'),
    ('milionar_autoplay_lifelines', '1'),
    ('milionar_tts_welcome', 'false'),
    ('milionar_tts_intro', 'false'),
    ('milionar_tts_question', 'false'),
    ('milionar_tts_options', 'false'),
    ('milionar_tts_result', 'false'),
    ('milionar_tts_transition', 'false'),
    ('milionar_tts_explanation', 'false'),
    ('milionar_tts_provider', 'OpenAI'),
    ('milionar_tts_voice', 'ash'),
    ('milionar_tts_model', 'gpt-4o-mini-tts-2025-03-20'),
    ('milionar_tts_voice_elevenlabs', 'Adam'),
    ('milionar_tts_model_elevenlabs', 'eleven_flash_v2_5'),
    # Knihovna
    ('autoplay_enabled_global', 'true'),
    ('autoplay_countdown_seconds', '45'),
    ('autoplay_trigger_seconds', '15'),
    ('library_auto_update', 'true'),
    # TMDb
    ('show_specials', 'false'),
    # AI
    ('ai_cost_currency', '2'),
    ('ai_provider', 'openai'),
    ('openai_model', 'gpt-4.1-mini'),
    ('anthropic_model', 'claude-sonnet-4-20250514'),
    ('google_model', 'gemini-2.5-flash'),
    ('mistral_model', 'mistral-large-latest'),
    ('groq_model', 'llama-3.3-70b-versatile'),
    ('openai_temperature', '0.7'),
    ('openai_top_p', '0.9'),
    ('openai_max_output_tokens', '2048'),
    ('anthropic_temperature', '0.7'),
    ('anthropic_top_p', '0.9'),
    ('anthropic_top_k', '5'),
    ('anthropic_max_tokens', '2048'),
    ('google_temperature', '0.7'),
    ('google_top_p', '0.9'),
    ('google_top_k', '40'),
    ('google_max_tokens', '2048'),
    ('mistral_temperature', '0.7'),
    ('mistral_top_p', '0.9'),
    ('mistral_max_tokens', '2048'),
    ('mistral_random_seed', '0'),
    ('groq_temperature', '0.7'),
    ('groq_top_p', '1.0'),
    ('groq_max_tokens', '2048'),
    ('ai_context_history_limit', '20'),
    ('ai_recommendation_count', '11'),
    ('ai_click_action', 'Zobrazit menu akcí'),
    ('ai_debug_mode', 'false'),
    ('ai_use_web_search', 'false'),
    # ČSFD
    ('csfd_cache_hours', '24'),
    ('csfd_tmdb_cache_days', '7'),
    ('csfd_items_per_page', '20'),
    ('csfd_series_items_per_page', '20'),
    # Stahování
    ('dnormalize', 'true'),
    ('dnotify', 'true'),
    ('dnevery', '1'),
]


def run_settings_migration(addon):
    """Jednorázová migrace: reset settings na defaulty položku po položce."""
    if addon.getSetting('settings_migration_v2') == 'done':
        return

    xbmc.log("[Milionář Service] Spouštím jednorázovou migraci settings", level=xbmc.LOGINFO)

    try:
        count = 0
        for setting_id, default_value in DEFAULT_SETTINGS:
            addon.setSetting(setting_id, default_value)
            count += 1

        addon.setSetting('settings_migration_v2', 'done')
        xbmc.log(f"[Milionář Service] Migrace dokončena: {count} položek nastaveno na default", level=xbmc.LOGINFO)

    except Exception as e:
        xbmc.log(f"[Milionář Service] Chyba migrace: {e}", level=xbmc.LOGERROR)


def main():
    """Autostart service pro doplněk Milionář"""
    xbmc.log("[Milionář Service] Spouštím se při startu Kodi", level=xbmc.LOGINFO)
    
    try:
        # Zkontrolovat existenci doplňku
        addon = xbmcaddon.Addon('plugin.video.milionar')
        xbmc.log("[Milionář Service] Doplňek nalezen", level=xbmc.LOGINFO)
        
        # Jednorázová migrace settings na nové defaulty
        run_settings_migration(addon)
        # Reload addon po migraci (settings se mohly změnit)
        addon = xbmcaddon.Addon('plugin.video.milionar')
        
        # Zkontrolovat nastavení autostart
        auto_start = addon.getSetting('auto_start_enabled')
        if auto_start == 'true':
            # Načíst čas čekání z nastavení (default 1 sekunda)
            try:
                delay_seconds = int(addon.getSetting('auto_start_delay_seconds') or '1')
            except (ValueError, TypeError):
                delay_seconds = 1
            
            xbmc.log(f"[Milionář Service] Autostart zapnut - čekám {delay_seconds} sekund", level=xbmc.LOGINFO)
            
            # Počkat podle nastavení
            xbmc.sleep(delay_seconds * 1000)  # Převod na milisekundy
            
            # Načíst akci z nastavení
            auto_start_action = addon.getSetting('auto_start_action')
            
            # Načíst nastavení notifikací
            show_notifications = addon.getSetting('auto_start_show_notifications')
            
            if auto_start_action == '0':  # Spustit doplněk
                xbmc.executebuiltin('RunAddon(plugin.video.milionar)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32197)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Doplňek spuštěn", level=xbmc.LOGINFO)
            elif auto_start_action == '1':  # Otevřít MyTV
                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.milionar/?action=my_tv_dialog)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32209)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Dialog MyTV spuštěn", level=xbmc.LOGINFO)
            elif auto_start_action == '2':  # Otevřít MyCinema
                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.milionar/?action=my_cinema_dialog)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32220)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Dialog MyCinema spuštěn", level=xbmc.LOGINFO)
            else:
                xbmc.log("[Milionář Service] Neznámá akce autostartu", level=xbmc.LOGWARNING)
        else:
            xbmc.log("[Milionář Service] Autostart vypnut", level=xbmc.LOGINFO)
        
        # VIP kontrola se provádí PO autostartu (nezávisle na tom, zda je zapnutý)
        xbmc.log("[Milionář Service] Začínám VIP kontrolu", level=xbmc.LOGINFO)
        check_vip_expiration(addon)
            
    except Exception as e:
        xbmc.log(f"[Milionář Service] Chyba: {e}", level=xbmc.LOGERROR)

def check_vip_expiration(addon):
    """Kontrola VIP expirace Webshare účtu při autostartu"""
    try:
        # Import WebshareClient pro použití existující funkce
        from wcs.webshare.WebshareClient import refresh_vip_info
        
        # Použít existující funkci s show_warning=True pro zobrazení varování
        refresh_vip_info(addon, show_warning=True, log_context="autostart_service")
        xbmc.log("[Milionář Service] VIP kontrola dokončena", level=xbmc.LOGINFO)
        
    except Exception as e:
        xbmc.log(f"[Milionář Service] VIP kontrola selhala: {e}", level=xbmc.LOGERROR)
        xbmc.executebuiltin(f'Notification(Milionář, VIP kontrola selhala: {e}, 3000)')

if __name__ == '__main__':
    main()
