#!/usr/bin/env python3
"""Generate high-resolution action button texture for Kodi - pill shape"""
from PIL import Image, ImageDraw

# Exact button dimensions - high res for crisp scaling
WIDTH = 400  # 2x for retina-quality
HEIGHT = 90  # 2x for retina-quality
RADIUS = 45  # Full pill shape (half of height)

# Create image with transparency
img = Image.new('RGBA', (WIDTH, HEIGHT), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw perfect white rounded rectangle (pill shape)
draw.rounded_rectangle(
    [(0, 0), (WIDTH - 1, HEIGHT - 1)],
    radius=RADIUS,
    fill=(255, 255, 255, 255)
)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/btn_action.png'
img.save(output_path, 'PNG')
print(f"Created: {output_path}")
print(f"Size: {WIDTH}x{HEIGHT}px, Radius: {RADIUS}px (pill shape)")
