# Milionář – Prompty pro typ Film/Seriál/Epizoda (kopírovatelné do kódu)

Níže jsou finální, samostatné prompty pro typ hry Film/Seriál/Epizoda. Každý prompt je nezávislý inference call, respektuje globální obtížnost `{difficulty_header}` a má jednotný JSON výstup. Bloky lze přímo vložit do funkcí v `wcs/ai_handler.py`.

**Poznámka:** Všechny tři typy (Film, Seriál, Epizoda) používají stejnou univerzální funkci `generate_millionaire_[easy/medium/hard]_questions()` s parametrem `media_type`.

---

## SNADNÁ (Film/Seriál/Epizoda)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 SNADNÉ otázky pro kvíz typu "Chcete být milionářem" o {media_context}.{plot_info}{genre_info}

OBTÍŽNOST: SNADNÁ - "Základní porozumění příběhu"
TÉMATA: Hlavní zápletka, klíčové události, základní postavy
CÍLOVÁ SKUPINA: Každý divák, kdo film/seriál/epizodu sledoval

PŘÍKLADY TÉMAT:
- Kdo je hlavní postava?
- Kde se odehrává příběh?
- Co je hlavní cíl protagonisty?
- Jak film/seriál/epizoda končí? (základní koncovka)
- Kdo je hlavní antagonista?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být JEDNODUCHÉ pro běžného diváka
- Zaměř se POUZE na základní děj a hlavní postavy
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## STŘEDNÍ (Film/Seriál/Epizoda)

```python
prompt = f"""{difficulty_header}Jsi expert na filmové kvízy. Vytvoř přesně 3 STŘEDNÍ otázky pro kvíz typu "Chcete být milionářem" o {media_context}.{plot_info}{genre_info}

OBTÍŽNOST: STŘEDNÍ - "Pozornost k detailům příběhu"
TÉMATA: Konkrétní scény/epizody, postavy a jejich motivace, dějové zvraty, symbolika
CÍLOVÁ SKUPINA: Pozorný divák si všimne

PŘÍKLADY TÉMAT:
- Jaká je klíčová scéna v [čas/epizodě]?
- Proč postava udělala [konkrétní věc]?
- Jaký je význam [symbolu]?
- Kdo řekl [konkrétní repliku]?
- Jak se vyvíjí vztah mezi [postavami]?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být STŘEDNÍ obtížnosti
- Zaměř se na DETAILY příběhu a postav
- Vyžadují lepší znalost filmu/seriálu/epizody, ne jen základní děj
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## TĚŽKÁ (Film/Seriál/Epizoda)

```python
prompt = f"""{difficulty_header}Jsi filmový historik. Vytvoř přesně 3 TĚŽKÉ otázky pro kvíz typu "Chcete být milionářem" o {media_context}.{plot_info}{genre_info}

OBTÍŽNOST: TĚŽKÁ - "Filmová/Seriálová erudice"
TÉMATA: Detailní trivia, produkční detaily, historické souvislosti, skryté významy
CÍLOVÁ SKUPINA: Skutečný znalec filmu/seriálu/epizody pozná

PŘÍKLADY TÉMAT:
- Jaké bylo původní jméno postavy?
- V kterém roce se natáčela [scéna/epizoda]?
- Jaký je skrytý význam [symbolu]?
- Kdo původně měl hrát [roli]?
- Jaké jsou alternativní konce?
- Jaký je význam [barvy] v filmu/seriálu?
- Kdo napsal původní scénář?

FORMÁT ODPOVĚDI (PŘESNĚ):
{{
  "questions": [
    {{
      "question": "Text otázky",
      "options": {{"A": "Možnost A", "B": "Možnost B", "C": "Možnost C", "D": "Možnost D"}},
      "correct": "A|B|C|D",
      "explanation": "Krátké vysvětlení správné odpovědi"
    }}
  ]
}}

DŮLEŽITÉ:
- Přesně 3 otázky
- Každá otázka má 4 možnosti (A, B, C, D)
- Správná odpověď jako písmeno (A, B, C nebo D)
- Otázky musí být TĚŽKÉ - pro skutečné znalce
- Zaměř se na DETAILNÍ TRIVIA a skryté významy
- Kombinace znalosti filmu/seriálu/epizody + filmové/televizní kultury
- KAŽDÁ MOŽNOST ODPOVĚDI MÁ MAXIMÁLNĚ 25 ZNAKŮ (včetně mezer) - buď stručná a jasná"""
```

---

## Implementace

### Funkce
```python
def generate_millionaire_easy_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
def generate_millionaire_medium_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
def generate_millionaire_hard_questions(media_type="movie", title="", plot="", genre="", episode_title="", season_number=None, episode_number=None)
```

### Logika rozlišení typu
```python
if media_type == "series":
    if episode_title:
        media_context = f'seriál "{title}", epizoda "{episode_title}"'
        if season_number and episode_number:
            media_context += f" (série {season_number}, epizoda {episode_number})"
    else:
        media_context = f'seriál "{title}"'
else:
    media_context = f'film "{title}"'
```

### Příklady použití
- **Film**: `media_type="movie", title="Matrix"`
- **Seriál**: `media_type="series", title="Breaking Bad"`
- **Epizoda**: `media_type="series", title="Breaking Bad", episode_title="Pilot", season_number=1, episode_number=1` 