## Úprava dialogu vyhledávání souborů z Webshare

### Cíl
Vylepšit dialog s výsledky vyhledávání tak, aby obsahoval horní informační blok s posterem a základními metadaty filmu/seriálu, decentní fanart na pozadí a pod tímto blokem úzký proužek s informací o hledaném výrazu. Seznam výsledků zůstává beze změny.

### Hlavní změny
- **Horní blok:**  
  - Vlevo poster filmu/seriálu.
  - Vedle posteru základní metadata: název, rok, žánr, délka, hodnocení.
- **Fanart:**  
  - Poloprůhledný fanart na pozadí dialogu (nepřekáží čitelnosti).
- **Proužek s hledaným výrazem:**  
  - Pod horním blokem bude úzký proužek s textem „Hledaný výraz: ..." oddělující hlavičku od seznamu výsledků.
- **Seznam výsledků:**  
  - Zůstává naprosto beze změny – rozložení, vzhled i funkce.

### Klíčové soubory
- `resources/skins/Default/1080i/search/DialogWcsSearch.xml` – úprava rozložení a přidání nových prvků do skinu.
- `wcs/ui/dialogs/DialogWcsSearch.py` – předávání metadat (poster, fanart, základní info) do skinu.

### Implementované změny

#### 1. MyList Dialog (`wcs/ui/dialogs/DialogWcsMyList.py`)
- **Problém:** Seriály z MyList dialogu zobrazovaly "Název seriálu – Název seriálu" místo "Název seriálu – Název epizody"
- **Řešení:** 
  - Přidáno načítání skutečného názvu epizody z TMDb API v `_execute_episode_overlay_action`
  - Implementováno načítání roku, žánru, hodnocení, délky epizody a posteru seriálu
  - Opraveno předávání `raw_episode_title` do search dialogu

#### 2. TMDb Menu (`wcs/metadata/TMDbClient.py`)
- **Problém:** Seriály z TMDb menu (seriály → sezóny → epizody) zobrazovaly obrázek epizody místo posteru seriálu
- **Řešení:**
  - Opraveno používání `episode_thumb` pro menu a `poster` pro search dialog
  - Přidáno načítání roku, žánru, hodnocení a délky epizody z TMDb API
  - Implementováno předávání všech metadat do `tmdb_params`

#### 3. SeriesSearch (`wcs/search/SeriesSearch.py`)
- **Problém:** Starý formát názvu "S01E01" místo "Název seriálu – Název epizody"
- **Řešení:**
  - Opravena logika v `_internal_search_and_select_series_file` pro správný formát názvu
  - Přidáno předávání `year` a `runtime` parametrů
  - Opraveno v `search_and_handle_episode` pro správný `display_title`

#### 4. Utils (`wcs/utils.py`)
- **Problém:** Funkce pro seriály nepodporovaly rok a délku epizody
- **Řešení:**
  - Přidány parametry `year` a `runtime` do `search_and_play_episode` a `search_and_select_episode_file`
  - Opravena logika pro správné použití `ep_name` ve formátu "Název seriálu – Název epizody"

### Aktuální stav a poznámky k implementaci

#### ✅ Plně funkční scénáře:
- **Filmy i seriály z knihovny Kodi** - metadata se načítají přes JSON-RPC, zpracovávají a předávají do dialogu jednotně
- **Filmy z doplňku** (detail dialog, My List) - předávání metadat funguje správně
- **Seriály z MyList dialogu** - kompletní metadata včetně správného formátu názvu
- **Seriály z TMDb menu** (seriály → sezóny → epizody) - kompletní metadata s posterem seriálu
- **Seriály z CSFD menu** - kompletní metadata přes `tmdb_episode_search` akci

#### Rozdělení logiky
- **Knihovna Kodi:** metadata se načítají přes JSON-RPC, zpracovávají a předávají do dialogu jednotně pro filmy i seriály
- **Doplněk:** metadata se předávají z různých míst (detail dialog, My List, TMDb menu, CSFD menu), pro filmy i seriály je vše funkční a dialog vypadá stejně jako pro obsah z knihovny
- **Poznámka:** Logika v Python třídách pro předávání metadat do dialogu je nyní jednotná pro filmy i seriály, dialog samotný je univerzální

### Zobrazovaná metadata v dialogu
- Název filmu/seriálu (pro seriály: Název seriálu – Název epizody)
- Rok
- Žánr
- Délka (min)
- Hodnocení
- Poster (obrázek vlevo)
- Fanart (pozadí)
- Hledaný výraz (proužek pod hlavičkou)
- Seznam výsledků (s technickými informacemi o souborech)

### ASCII schéma rozložení dialogu

+-------------------------------------------------------------+
| [Poster]   Název filmu/seriálu – Název epizody              |
|            Rok   Žánr   Délka   Hodnocení                   |
|-------------------------------------------------------------|
| Hledaný výraz: ...                                         |
|-------------------------------------------------------------|
| Seznam výsledků (soubory, kvalita, jazyk, velikost, atd.)   |
+-------------------------------------------------------------+

### Implementované soubory a funkce

#### Hlavní změny:
1. **`wcs/ui/dialogs/DialogWcsMyList.py`**
   - `_execute_episode_overlay_action()` - načítání kompletních metadat z TMDb API
   - Předávání `raw_episode_title` pro správný formát názvu

2. **`wcs/metadata/TMDbClient.py`**
   - `display_season_episodes()` - načítání roku, žánru, hodnocení, délky epizody
   - Oprava používání posteru seriálu místo obrázku epizody
   - Předávání všech metadat do `tmdb_params`

3. **`wcs/search/SeriesSearch.py`**
   - `_internal_search_and_select_series_file()` - oprava formátu názvu
   - `search_and_handle_episode()` - předávání `year` a `runtime`
   - Přidání parametrů pro rok a délku epizody

4. **`wcs/utils.py`**
   - `search_and_play_episode()` - přidání parametrů `year` a `runtime`
   - `search_and_select_episode_file()` - oprava logiky pro správný formát názvu

#### Cache podpora:
- Všechna TMDb API volání používají cache z `TMDbCache.py`
- Data se načítají pouze při potřebě (kliknutí na epizodu)
- Optimalizováno pro minimální počet API volání

---

**Závěr:**
- Dialog je nyní plně funkční pro filmy i seriály z knihovny a pro filmy i seriály z doplňku ve všech scénářích.
- Všechna metadata epizod/seriálů jsou nyní zobrazena stejně jako z knihovny.
- Implementace je konzistentní napříč všemi vstupními body (MyList, TMDb menu, CSFD menu, knihovna).