# Nastavení defaultní akce při kliknutí na film

## Popis funkce
Přidání možnosti nastavit, co se stane při kliknutí na film v doplňku - buď zobrazení detailů, nebo přehrání ihned.

## Implementované změny

### 1. Nastavení (settings.xml)
**Nová sekce**: "Chování doplňku" v sekci "Přehrávání médií"

**Nové ID pro lokalizaci**:
- `40001` - Nadpis sekce "Chování doplňku"
- `40002` - "Výchozí akce"
- `40003` - "Zobrazit detaily"
- `40004` - "Přehrát ihned"

**Nové nastavení**:
- `default_movie_action` - select s možnostmi (0 = zobrazit detaily, 1 = přehrát ihned)

### 2. Lokalizace
**Přidáno do všech jazyků**:
- `resource.language.cs_cz/strings.po`
- `resource.language.en_gb/strings.po`
- `resource.language.sk_sk/strings.po`

### 3. Logika přepínání
**Implementováno v `wcs/ui/UI.py` ve všech funkcích pro zobrazení filmů**:

**Funkce `display_movie_list`** - výsledky z TMDb:
- **Stav 1** (default_action = 0): Kliknutí na film → Zobrazit detailní dialog (současné chování)
- **Stav 2** (default_action = 1): Kliknutí na film → PŘEHRÁT IHNED akce (stejná jako v kontextovém menu)

**Funkce `display_added_movies`** - "Moje filmy":
- **Stav 1** (default_action = 0): Kliknutí na film → Zobrazit detailní dialog (současné chování)
- **Stav 2** (default_action = 1): Kliknutí na film → PŘEHRÁT IHNED akce (stejná jako v kontextovém menu)

**Funkce `display_my_added_items`** - "Moje přidané":
- **Stav 1** (default_action = 0): Kliknutí na film → Zobrazit detailní dialog (současné chování)
- **Stav 2** (default_action = 1): Kliknutí na film → PŘEHRÁT IHNED akce (stejná jako v kontextovém menu)

### 4. Použité existující akce
- `show_wcs_details` - zobrazení detailů (už existuje)
- `play_movie_from_addon` - přehrání ihned (už existuje)

**Žádné nové akce nebyly vytvořeny** - používáme pouze existující funkcionalitu.

### 5. Debug logy
**Přidány logy pro sledování chování**:
- Loguje se nastavení `default_movie_action` pro každý film
- Loguje se, která akce se používá (PLAY nebo DETAILS)
- Logy jsou označené podle funkce (My Movies, My Added Items, atd.)

### 6. Pokrytí funkcionality
**Nastavení se aplikuje na všechny sekce s filmy**:
- ✅ TMDb výsledky hledání a procházení
- ✅ Moje filmy (přidané filmy)
- ✅ Moje přidané (sloučený seznam)
- ✅ Všechny kategorie a žánry
- ✅ Všechny stránky výsledků