import xbmcgui
import xbmcaddon
import os
from wcs.ui.dialogs.guide.DialogLibraryGuide import LibraryGuideDialog

DIALOG_XML = 'login/DialogLibraryFolder.xml'

"""Dialog pro volbu knihovních složek; používá sjednocený LibraryGuideDialog."""

class LibraryFolderDialog(xbmcgui.WindowXMLDialog):
    def __init__(self, xmlFilename, addonPath, skin='Default', theme='1080i', **kwargs):
        super().__init__(xmlFilename, addonPath, skin, theme)
        self.addon = kwargs.get('addon')
        self.media_type = kwargs.get('media_type')
        self.result = False

    def onInit(self):
        if self.media_type == 'movie':
            self.getControl(7301).setLabel('Nastavení složky pro filmy')
            self.getControl(7302).setLabel('Pro přidání filmu do knihovny je nutné vybrat složku pro filmy.')
        else:
            self.getControl(7301).setLabel('Nastavení složky pro seriály')
            self.getControl(7302).setLabel('Pro přidání seriálu do knihovny je nutné vybrat složku pro seriály.')
        self.getControl(7201).setLabel('Vybrat složku')

    def onClick(self, controlId):
        if controlId == 7201:
            if self.media_type == 'movie':
                setting_id = 'library_movies_folder'
                label = 'Složka knihovny pro filmy'
            else:
                setting_id = 'library_series_folder'
                label = 'Složka knihovny pro seriály'
            folder = xbmcgui.Dialog().browse(3, label, 'video')
            if folder and os.path.isdir(folder):
                self.addon.setSetting(setting_id, folder)
                self.result = True
                self.close()
        elif controlId == 7202:
            # Otevřít návod jako WindowXMLDialog s podporou zavření
            try:
                guide_dialog = LibraryGuideDialog(
                    'guide/DialogLibraryGuide.xml',
                    self.addon.getAddonInfo('path'),
                    'Default',
                    '1080i'
                )
                guide_dialog.doModal()
                del guide_dialog
            except Exception as e:
                xbmcgui.Dialog().ok("Chyba", f"Nelze otevřít návod: {e}")
        elif controlId == 7203:
            self.close()

def show_library_folder_dialog(addon, media_type):
    dialog = LibraryFolderDialog(
        DIALOG_XML,
        addon.getAddonInfo('path'),
        'Default',
        '1080i',
        addon=addon,
        media_type=media_type
    )
    dialog.doModal()
    result = dialog.result
    del dialog
    return result 