#!/usr/bin/python
# -*- coding: utf-8 -*-

import xbmc
import xbmcaddon
import time
import datetime

def main():
    """Autostart service pro doplněk Milionář"""
    xbmc.log("[Milionář Service] Spouštím se při startu Kodi", level=xbmc.LOGINFO)
    
    try:
        # Zkontrolovat existenci doplňku
        addon = xbmcaddon.Addon('plugin.video.milionar')
        xbmc.log("[Milionář Service] Doplňek nalezen", level=xbmc.LOGINFO)
        
        # Zkontrolovat nastavení autostart
        auto_start = addon.getSetting('auto_start_enabled')
        if auto_start == 'true':
            # Načíst čas čekání z nastavení (default 1 sekunda)
            try:
                delay_seconds = int(addon.getSetting('auto_start_delay_seconds') or '1')
            except (ValueError, TypeError):
                delay_seconds = 1
            
            xbmc.log(f"[Milionář Service] Autostart zapnut - čekám {delay_seconds} sekund", level=xbmc.LOGINFO)
            
            # Počkat podle nastavení
            xbmc.sleep(delay_seconds * 1000)  # Převod na milisekundy
            
            # Načíst akci z nastavení
            auto_start_action = addon.getSetting('auto_start_action')
            
            # Načíst nastavení notifikací
            show_notifications = addon.getSetting('auto_start_show_notifications')
            
            if auto_start_action == '0':  # Spustit doplněk
                xbmc.executebuiltin('RunAddon(plugin.video.milionar)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32197)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Doplňek spuštěn", level=xbmc.LOGINFO)
            elif auto_start_action == '1':  # Otevřít Můj seznam
                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.milionar/?action=my_list_dialog)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32198)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Dialog Můj seznam spuštěn", level=xbmc.LOGINFO)
            elif auto_start_action == '2':  # Otevřít Continue Watching
                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.milionar/?action=continue_watching_dialog)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32202)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Dialog Continue Watching spuštěn", level=xbmc.LOGINFO)
            elif auto_start_action == '3':  # Otevřít MyTV
                xbmc.executebuiltin('RunPlugin(plugin://plugin.video.milionar/?action=my_tv_dialog)')
                if show_notifications == 'true':
                    notification_text = addon.getLocalizedString(32209)
                    xbmc.executebuiltin(f'Notification(Milionář, {notification_text}, 3000)')
                xbmc.log("[Milionář Service] Dialog MyTV spuštěn", level=xbmc.LOGINFO)
            else:
                xbmc.log("[Milionář Service] Neznámá akce autostartu", level=xbmc.LOGWARNING)
        else:
            xbmc.log("[Milionář Service] Autostart vypnut", level=xbmc.LOGINFO)
        
        # VIP kontrola se provádí PO autostartu (nezávisle na tom, zda je zapnutý)
        xbmc.log("[Milionář Service] Začínám VIP kontrolu", level=xbmc.LOGINFO)
        check_vip_expiration(addon)
            
    except Exception as e:
        xbmc.log(f"[Milionář Service] Chyba: {e}", level=xbmc.LOGERROR)

def check_vip_expiration(addon):
    """Kontrola VIP expirace Webshare účtu při autostartu"""
    try:
        # Import WebshareClient pro použití existující funkce
        from wcs.webshare.WebshareClient import refresh_vip_info
        
        # Použít existující funkci s show_warning=True pro zobrazení varování
        refresh_vip_info(addon, show_warning=True, log_context="autostart_service")
        xbmc.log("[Milionář Service] VIP kontrola dokončena", level=xbmc.LOGINFO)
        
    except Exception as e:
        xbmc.log(f"[Milionář Service] VIP kontrola selhala: {e}", level=xbmc.LOGERROR)
        xbmc.executebuiltin(f'Notification(Milionář, VIP kontrola selhala: {e}, 3000)')

if __name__ == '__main__':
    main()
