# Knowledge: MyTV

**Vytvořeno**: 2026-02-08 10:24
**Scope**: Kompletní MyTV modul - kanálová televize se seriály
**Zdroj**: text

## Účel

MyTV je funkce "televize budoucnosti" - uživatel si vytváří vlastní TV kanály s navolenými seriály. Systém automaticky generuje TV program (next-up epizody) a umožňuje souvislé přehrávání jako skutečná televize.

## Soubory

| Soubor | Účel | Řádků |
|--------|------|-------|
| [DialogMyTV.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py) | Hlavní dialog - UI, program, přehrávání | 2485 |
| [MediaChannelManager.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/MediaChannelManager.py) | CRUD kanálů, composite ikony, random epizody | 474 |
| [ChannelHistory.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ChannelHistory.py) | Per-kanálová historie sledování (JSON) | 248 |
| [ChannelNameGenerator.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ChannelNameGenerator.py) | AI/žánrové automatické pojmenování kanálů | 502 |
| [DialogAddMedia.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogAddMedia.py) | Inline dialog pro přidávání seriálů do kanálu | 953 |
| [DialogContinueWatching.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogContinueWatching.py) | Dialog "Pokračovat ve sledování" | 321 |
| [DialogMyTV.xml](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV.xml) | XML layout (pozadí, kanály, grid, program) | 2897 |
| [router.py](file:///Users/stanislavchudacek/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/router.py) | Router integrace (akce `my_tv_dialog`, play) | - |

## Hlavní funkce

### MyTVDialog (WindowXML)

Hlavní třída dialogu, dědí z `AIChatRecommendationDialog`.

**Klíčové control ID:**
- `2000` - Channel List (horizontální seznam kanálů dole)
- `9100` - Editor Grid (seriály v kanálu)
- `9000` - Program List (nadcházející epizody)
- `9001-9006` - Akční tlačítka (play, delete, confirm)
- `9020-9022` - Play Selection Dialog (kanál mix / jen seriál / zrušit)
- `9300-9305` - Series Detail Dialog (info, smazat, hra, podobné, přehrát)

**Inicializace (`onInit`):**
1. Reset stavu, nastavení labels
2. Setup background mode (static/fanart/still/collage)
3. `refresh_channels_view()` - naplní channel list
4. `update_editor_view()` - zobrazí seriály vybraného kanálu
5. `refresh_program_view()` - debounced async load programu

**Program Loading (`refresh_program_view` -> `_async_program_load`):**
1. Debounce 300ms - zamezí spamování při scrollu
2. Instant load z cache (`_instant_load_from_cache`)
3. Background thread: shuffle seriálů, fetch next-up epizod z TMDb
4. Progressive loading - položky se přidávají do UI jednotlivě
5. Nastavení: `mytv_upcoming_count` (počet epizod), `mytv_block_size` (epizod za sebou)
6. Cache s 7-denním TTL přes centralizovaný `CacheManager`
7. Token systém pro cancellaci při navigaci

**Přehrávání:**
- `_play_broadcast()` - všechny epizody v programu jako playlist
- `_play_current_channel()` - náhodná next-up epizoda
- `_play_series_only()` - jen epizody vybraného seriálu od pozice
- `_play_channel_from_selected()` - kanál od vybrané pozice + generování dalších
- Všechny varianty používají `mytv_channel_id` pro kanálovou historii

**Inline Dialogy:**
- **AddSeriesDialog** - zobrazí se přes properties `WCS.MyTV.AddDialog.*`
- **SeriesDetailDialog** - detail seriálu s akcemi (smazat, přehrát, hra, podobné)
- **PlaySelectionDialog** - výběr režimu přehrávání
- **DeleteConfirmation** - inline potvrzení mazání kanálu/seriálu

### MediaChannelManager

Spravuje kanály - unified pro MyTV (seriály) i MyCinema (filmy).

- Storage přes `user_data` (JSON), klíč `mytv_channels` / `mycinema_channels`
- `Channel` class: `id`, `name`, `icon`, `media_list`, `channel_type`
- Backward compat: `series_list` property mapuje na `media_list`
- `generate_channel_composite()` - PIL 2x2 grid posterů jako ikona kanálu
- `get_random_episode_for_channel()` - random next-up epizoda přes TMDb
- `MyTVChannelManager = MediaChannelManager` (alias)

### ChannelHistory

Per-kanálová historie sledování, oddělená od globální.

- Každý kanál má vlastní JSON (`{series_id: {season, episode}}`)
- `update_series_progress()` - aktualizuje progress po přehrání
- `get_series_progress()` - vrací `(season, episode)` nebo `(1, 0)`
- `migrate_from_global_history()` - jednorázová migrace z globální historie
- `check_and_migrate_if_needed()` - automatická migrace při prvním použití

### ChannelNameGenerator

Automatické pojmenování kanálů podle žánrů seriálů.

- Předdefinované české názvy dle žánrů (Drama, Sci-Fi, Komedie...)
- Formát: "žánr - kreativní název" (např. "Drama - Lidské osudy")
- AI varianta: LLM generuje kreativní název
- Podpora single/combined žánrů

### DialogAddMedia

Inline dialog pro přidávání seriálů do kanálu. Sdílený s MyCinema.

**Zdroje přidávání:**
1. Moje seriály (z knihovny)
2. Ruční vyhledávání (TMDb search)
3. TMDb - populární / top rated / trending
4. AI doporučení (s loading animací a fun messages)

**Akce na položce:**
- Přidat do kanálu
- Přidat do knihovny
- Najít podobné (TMDb similar)
- Hrát hru (Milionář)

## Flow

```mermaid
graph TD
    A[Router: my_tv_dialog] --> B[show_my_tv_dialog]
    B --> C[MyTVDialog.doModal]
    C --> D[onInit]
    D --> E[refresh_channels_view]
    D --> F[refresh_program_view]
    F --> G[_instant_load_from_cache]
    F --> H[_async_program_load]
    H --> I[TMDb: get_next_episode]
    H --> J[_add_single_program_item]
    
    C --> K{Uživatel klikne}
    K --> L[Kanál - update editor/program]
    K --> M[Vytvořit kanál -> AddSeriesDialog]
    K --> N[Program item -> PlaySelectionDialog]
    K --> O[Spustit vysílání -> playlist]
    K --> P[Grid item -> SeriesDetailDialog]
    
    O --> Q[Router: play_episode_from_addon_playlist]
    Q --> R[utils.resolve_episode_for_playlist]
    R --> S[ChannelHistory.update_series_progress]
```

## Závislosti

- **TMDbClient** - metadata epizod, posterů, fanartů
- **CacheManager** (`wcs.caching`) - cache epizod s 7-denním TTL
- **user_data** - persistence kanálů
- **PIL/Pillow** - composite ikony, background efekty (volitelné)
- **AIChatRecommendationDialog** - rodičovská třída (AI sidebar, navigace)
- **AIProvider** - pro AI pojmenování kanálů a doporučení
- **LibraryManager** - Moje seriály jako zdroj pro přidávání

## Nastavení (settings.xml)

- `mytv_upcoming_count` - počet epizod v programu (default 12)
- `mytv_block_size` - epizod jednoho seriálu za sebou (např. "1-3")
- Background mode - static/fanart/still/collage varianty
- Animation enabled/disabled

## Poznámky

- **Debounce pattern** - `refresh_program_view` používá 300ms timer + token systém pro cancellaci
- **Progressive loading** - epizody se přidávají do UI jednotlivě, ne najednou
- **Dual play mode** - `play_episode_from_addon` (single) vs `play_episode_from_addon_playlist` (setResolvedUrl)
- **Channel history oddělená** - každý kanál trackuje progress samostatně, ne globálně
- **Background thread safety** - token check před každým UI updatem v async methodě
- **MyTVDialog dědí z AIChatRecommendationDialog** - sdílí AI sidebar, navigační panel
- **MediaChannelManager** je unified pro TV i Cinema (`channel_type` parametr)
