---
description: Create Kodi addon user guide
---

# /user-guide

Syntax: `/user-guide` or `/do user-guide`

Creates `docs/USER_GUIDE.md` -- a guide for addon users.

FORBIDDEN to include:
- Python code, XML structures
- Class, function, module names
- Technical terms (callback, thread, API...)

## Procedure

### 1. Complete Analysis
Review:
- XML layouts -> addon screens
- Python modules -> user-facing features
- `resources/settings.xml` -> settings
- Existing docs/

### 2. Feature Mapping
Screen -> Feature -> Section in guide

### 3. Guide Structure
- Introduction (what the addon can do)
- Installation
- Quick start
- Controls (navigation in Kodi)
- Features (section for each screen)
- Settings (table)
- Troubleshooting
- FAQ

## Technical Term Rewrites
- "Calls API" -> "Loads data"
- "XML window" -> "Screen"
- "Control focus" -> "Highlighted item"
- "Addon settings" -> "Settings"

## Checks
- Does every screen have a section?
- Are all features covered?
- No technical terms?
