---
description: Technology research using kodi-researcher skill
---

# /research

Syntax: see `workflow-syntax.md` -- scope: technology/topic, `/do` = research + implementation

## Purpose
Technology research:
1. Understand topic from context or brief
2. Web search with current year
3. Verify compatibility and support
4. Define fallback strategies
5. Save report to `docs/research/`
6. Without `/do`: WAIT for user

## Sources
- Current dialog
- Web search
- Kodi Wiki, Kodi Forum
- Official Kodi Python API docs

## Steps

### 1. Understand Topic
Dialog about technology -> use context, otherwise -> ask

### 2. Load kodi-researcher Skill
Follow its procedures.

### 3. Perform Research
1. Get current year from metadata
2. Web search: `[TECHNOLOGY] [TOPIC] [YEAR]`
3. Verify Kodi version compatibility
4. Define fallback for each new technology

Priority sources: Kodi Wiki, Kodi Forum, Doxygen API docs

### 4. Create Report
Save to `docs/research/[topic]-research.md`:
- Findings table (feature, support, fallback)
- Detailed analysis per feature
- Recommendations
- Risks and mitigation

### 5. Without `/do`: WAIT for user

## Combinations
- `/research` -- research only
- `/research /do` -- research + implementation
- `/research /analyze` -- research + impact analysis
