---
description: Agent reconfiguration -- changes rules, skills and workflows for a new domain/user needs
---

# /mind Workflow

**Meta-tool for total agent reconfiguration.**

Transforms entire configuration (`.agent/rules/`, `.agent/skills/`, `.agent/workflows/`) to a new domain while preserving structure and interaction style.

> [!CAUTION]
> **DESTRUCTIVE OPERATION!** Overwrites existing configuration.
> Requires explicit user approval.

---

## Procedure

### 1. GREET the user

**Without parameter** (`/mind`) -- show full greeting:

1. Create an **original ASCII art banner** -- stylized "MIND" text or metamorphosis symbol
2. Use box-drawing characters (`╔═╗║╚╝`) for the frame
3. Be creative -- each invocation can have a unique design

> *Hi! I'm your agent and I can transform into anything.*
> 
> Lawyer, creative writer, business strategist, researcher...
> **Tell me what I should become.**

Then launch **Interactive Discovery Dialog** (section below).

---

**With parameter** (`/mind [domain]`) -- quick confirmation:

> **Transformation:** *[given domain]*
> 
> Preparing reconfiguration...

Skip dialog and continue to step **2. ANALYZE current state**.

---

### 2. DETERMINE target domain

```
IF user provided parameter:
    Use given domain -> continue to step 3
ELSE:
    Launch INTERACTIVE DISCOVERY DIALOG (see section below)
```

---

## Interactive Discovery Dialog

When user calls `/mind` without parameter, lead a **multi-level A/B/C dialog**:

### Dialog Rules

1. **Always offer 3-5 specific options** + escape variants
2. **Contextually adapt** -- suggestions depend on previous answers
3. **Progressively narrow** -- from general to specific
4. **Wait for answer** -- never continue without user's choice

---

### Question Format

**[Question in natural language]**

| | |
|---|---|
| **A)** | Option one |
| **B)** | Option two |
| **C)** | Option three |
| --- | --------------- |
| **D)** | More suggestions... |
| **E)** | Custom answer |

---

### Example Flow

#### Level 1 -- Area

**What area do you want to focus on?**

| | |
|---|---|
| **A)** | Research / Analysis |
| **B)** | Creative Writing |
| **C)** | Business / Strategy |
| **D)** | Education / Mentoring |
| --- | --------------- |
| **E)** | More suggestions... |
| **F)** | Custom answer |

---

#### Level 2 -- Specification *(after choosing A)*

**What type of research?**

| | |
|---|---|
| **A)** | Technological *(APIs, frameworks, tools)* |
| **B)** | Academic *(studies, reviews, citations)* |
| **C)** | Market *(competition, trends, analysis)* |
| **D)** | Legal *(legislation, contracts, compliance)* |
| --- | --------------- |
| **E)** | More suggestions... |
| **F)** | Custom answer |

---

#### Level 3 -- Style *(after choosing B)*

**What should the output style be?**

| | |
|---|---|
| **A)** | Formal academic *(citations, structure)* |
| **B)** | Brief summary *(bullet points)* |
| **C)** | Actionable recommendations *(what to do)* |
| --- | --------------- |
| **D)** | More suggestions... |
| **E)** | Custom answer |

---

#### Final Confirmation

**Did I understand correctly?**

| Parameter | Value |
|-----------|-------|
| **Role** | Academic researcher |
| **Style** | Formal with citations |
| **Outputs** | Structured reviews |

> Do you agree? *(yes / adjust / cancel)*

---

### 2. ANALYZE current state

Explore and document:

| Folder | Content | Count |
|--------|---------|-------|
| `.agent/rules/` | Behavior rules | X files |
| `.agent/skills/` | Skills | X folders |
| `.agent/workflows/` | Slash commands | X files |

### 3. PROPOSE mapping

**Workflows (preserve commands):**

| Original | New purpose |
|----------|-------------|
| `/analyze` | [new purpose] |
| `/audit` | [new purpose] |
| `/brainstorm` | [new purpose] |
| `/do` | Unchanged |
| `/explain` | Unchanged |
| `/fix` | [new purpose] |
| `/research` | [new purpose] |
| `/feature` | [new purpose] |
| `/issue` | [new purpose] |
| `/debug` | [new purpose or remove] |

**Rules (adapt):**

| Original | New |
|----------|-----|
| `czech-communication.md` | Preserve |
| `no-browser-testing.md` | -> `[domain]-restrictions.md` |

**Skills (transform):**

| Original | New equivalent |
|----------|----------------|
| `kodi-researcher` | `[domain]-researcher` |
| `kodi-refactorer` | `[domain]-optimizer` |
| ... | ... |

### 4. PRESENT plan for approval

```markdown
# Transformation: [Original] -> [New Domain]

## Preserved (no change)
- `/do`, `/explain`
- `czech-communication.md`

## Transformed
[list of changes]

## Removed
[list of irrelevant]

## New
[list of new for domain]
```

### 5. WAIT for approval

> [!IMPORTANT]
> **STOP! Without explicit approval DO NOT PROCEED:**
> - "yes" / "ok" / "continue" -> execute transformation
> - Adjustments -> modify plan and ask again
> - "no" -> cancel operation

### 6. EXECUTE transformation

// turbo-all

After approval:

1. **Backup** current state to `.agent/backup/YYYY-MM-DD/`
2. **Rewrite** rules according to mapping
3. **Rewrite** skills according to mapping
4. **Rewrite** workflows according to mapping
5. **Verify** consistency (no missing references)

### 7. SUMMARIZE result

```markdown
# Transformation Complete

**Original:** [X] -> **New:** [Y]

## Changes
- Workflows: X modified
- Rules: X modified
- Skills: X modified

## Available commands
[list with descriptions]
```

---

## Transformation Examples

### Kodi Development -> Legal Analysis

| Original | New |
|----------|-----|
| `/debug` -> `/review` | Contract review |
| `/fix` -> `/correct` | Legal defect correction |
| `kodi-researcher` -> `legal-researcher` | Legal research |

### Kodi Development -> Conversational Agent

| Original | New |
|----------|-----|
| `/debug` -> `/reflect` | Thought reflection |
| `/fix` -> `/revise` | Conclusion revision |
| `kodi-researcher` -> `topic-researcher` | Topic research |

---

## Checklist

> [!IMPORTANT]
> **BEFORE EXECUTION:**
> - [ ] Discovery dialog completed OR parameter provided
> - [ ] Target domain clearly defined
> - [ ] Mapping covers all existing files
> - [ ] User explicitly approved plan
> - [ ] Universal commands (`/do`, `/explain`) remain

> [!CAUTION]
> **AFTER EXECUTION:**
> - [ ] Backup created in `.agent/backup/`
> - [ ] All files are valid markdown
> - [ ] No missing references between files
> - [ ] Agent responds correctly to slash commands
