---
description: Create or update product landing page
---

# /landing

Syntax: see `workflow-syntax.md` -- `/do` = create without asking

Use skills `landing-page-master`, `premium-web-designer`, `responsive-design`.

## Prerequisites
- `docs/README.md` exists
- `docs/USER_GUIDE.md` exists
- CTA destination is clear

## Procedure

### 1. Product Analysis
Review documentation:
- `docs/README.md` -> what the product does
- `docs/USER_GUIDE.md` -> features and user flows
- Screenshots in `docs/`

Extract: value proposition, target audience, top features, unique selling points.

### 2. Structure
```
/landing
├── index.html
├── css/landing.css
├── js/landing.js
└── assets/images/, icons/
```

### 3. Implementation
Order: CSS -> HTML -> JS

Rules:
- Relative paths
- Mobile-first
- No placeholders
- CTA links to the application

### 4. Section Content
Hero, Problem/Solution, Features, How It Works, Final CTA, Footer

### 5. Visual Elements
- Screenshots from `docs/screenshots/`
- Generate custom graphics with `kodi-image-generator` skill
- Scroll-driven animations
- Hover effects

## What NOT to Do
- Do not copy CSS from main application
- Do not use Lorem ipsum
- Do not forget mobile
