---
description: Fix audit findings and refactor code
---

# /fix

Syntax: see `workflow-syntax.md` -- scope: finding name/description/CRITICAL/WARNING, `/do` = fix without asking

## Usage
- `/fix 001-name.md` -- specific finding
- `/fix CRITICAL` -- all CRITICAL findings
- `/fix WARNING` -- all WARNING findings
- `/fix` -- interactively review findings

Findings are in `docs/audits/`.

## Rules
- Use skill `kodi-refactorer`
- Use skill `kodi-researcher` for best practices
- Use existing patterns in codebase

## Procedure
1. Read audit document
2. Identify affected files
3. Propose minimal changes
4. Preserve backward compatibility
5. Implement with `kodi-refactorer` skill
6. Update audit document (status: FIXED, fix date)

## Combinations
- `/fix` -- asks what to fix, then fixes
- `/explain /fix` -- explains, waits for confirmation
- `/do /fix CRITICAL` -- fixes everything without asking
