---
description: Multi-level concise dialog for extracting user needs from context
---

# /dialog

Concise, straightforward dialog. Goal: get exactly what user needs.

Combinable: `/explain /dialog`, `/analyze /dialog` -- other workflow executes first.

## Procedure

### 1. Preparation
- Load relevant skills based on situation context
- Follow all rules
- **Do not analyze open files**

### 2. Understanding (100% knowledge)
- Analyze needed parts of codebase
- Understand how relevant code works
- Get context from chat history

### 3. Dialog
- Ask 1-3 concise, direct questions
- No unnecessary sentences
- Wait for answer

### 4. Iteration
- Based on answer, clarify or proceed
- Repeat until output is clear
- Maximum 3-4 levels

### 5. Conclusion
- Summarize what user needs (1-2 sentences)
- Propose next step

## Dialog Rules
- **Brevity** -- each question max 1-2 sentences
- **Directness** -- no beating around the bush
- **Specificity** -- ask for specifics
- **Active listening** -- respond to answers

## Example Questions
- "Do you want X or Y?"
- "How should it work exactly?"
- "What's the priority?"
- "Is there anything that must not be?"
