---
description: Audit codebase -- finds issues, duplicates, inefficiencies and refactoring suggestions
---

# /audit

Syntax: see `workflow-syntax.md` -- scope: Python/XML/component, `/fix` = audit + fix

## Modes
- `/audit` -- entire codebase
- `/audit Python` or `/audit XML` -- specific technology only
- `/audit [component]` -- specific part

## Check Against
1. Rules in `.agent/rules/`
2. Skill `kodi-researcher` for best practices
3. Skill `config-auditor` for rules/skills review

## Finding Categories
- DUPLICATE -- duplicated code (DRY violation)
- INEFFICIENCY -- inefficient solution
- BUG -- potential bug
- REFACTOR -- refactoring suggestion
- COMPATIBILITY -- compatibility issue
- STRUCTURE -- project structure violation
- LANGUAGE -- non-English text in `.agent/` config files (rules, skills, workflows must be in English for optimal LLM comprehension)

## Severity
- CRITICAL -- must fix (bug, security)
- WARNING -- should fix (inefficiency, duplication)
- INFO -- improvement suggestion

## Procedure
1. Analyze scope (entire codebase / technology / part)
2. Use skills: `kodi-researcher`, `config-auditor`
3. Go through files systematically
4. **Check `.agent/` files for non-English content** -- flag as LANGUAGE finding
5. Record findings in `docs/audits/[XXX]-[name].md`
6. Create summary `docs/audits/YYYY-MM-DD-summary.md`

## Finding Format
```
# Audit: [Name]
## Type: [DUPLICATE/BUG/LANGUAGE/...]
## Severity: [CRITICAL/WARNING/INFO]
## Created: [YYYY-MM-DD HH:mm]

## Problem
[description]

## Where
- [file](file:///path) -- lines X-Y

## Why It's a Problem
[impact]

## Recommended Solution
[suggestion without implementation]
```

## Rules
- Do not suggest solutions you haven't tested
- Reference existing patterns
- Use `kodi-researcher` for verification
