---
description: Analyze a problem and propose solutions -- deep analysis without implementation
---

# /analyze

Syntax: see `workflow-syntax.md` -- scope: component/description/screenshot, `/do` = analysis + implementation

## Purpose
Deep problem analysis:
1. Understand the problem from dialog context or screenshot
2. Explore relevant parts of the code
3. Identify causes and risks
4. Propose solutions ranked by effectiveness
5. Without `/do`: WAIT for user

## Sources
- Current dialog (primary source of the problem)
- Screenshot (visual reference -- "this doesn't work as expected")
- `.agent/rules/` -- project rules
- `.agent/skills/` -- best practices
- Codebase -- architecture

## Screenshot as Input
If user provides a screenshot:
- Analyze as **iPhone PWA** in standalone mode
- Compare with current implementation
- Identify differences (what's broken vs. how it should look)
- Be PRECISE in details

Do NOT browse `docs/` -- save tokens.

## Steps

### 1. Understand the Problem
- Dialog -> use context
- Screenshot -> analyze visual + compare with code
- Nothing -> ask the user

### 2. Explore Context
- Load relevant rules
- Study relevant skills
- Identify affected files

### 3. Identify Causes
For each cause:
- What causes the problem
- Where in code (files/functions)
- Why it occurred

### 4. Evaluate Risks
- HIGH -- may break other functionality
- MEDIUM -- requires careful testing
- LOW -- isolated change

### 5. Propose Solutions
Rank by effectiveness (benefit/effort):
- Approach, affected files, risk, effort

### 6. Present Analysis
Structure: Problem -> Causes -> Risks -> Proposals -> Recommendation

### 7. Without `/do`: WAIT for user
Wait for: approval, variant selection, further questions, or `/do`

## Combinations
- `/analyze` -- analysis only
- `/analyze /do` -- analysis + implementation
- `/analyze /fix` -- analysis + fix per audit
