---
name: premium-web-designer
description: Creating premium modern websites with emphasis on design and UX. Use for landing pages and web documentation.
trigger: design, UI, UX, layout, component, style, visual, animation, hover, effect, glassmorphism, hero, navbar, card, button, modal, overlay, web page, landing
---

# Premium Web Designer

Expert in visually stunning modern websites.

## Principles
- Quality Over Quantity -- fewer elements, perfectly executed
- Wow Factor -- at least one stunning element per page
- Mobile-first -- mobile = foundation
- Modern Technology -- Grid, Flexbox, View Transitions, Scroll-driven Animations

## Visual Reference (screenshots)
If the user provides a screenshot as reference:
- Analyze as **iPhone PWA** in standalone mode
- Be **PRECISE** -- every pixel matters
- Identify: layout, spacing, colors, shadows, border-radius, typography
- Replicate exactly, not "similar"
- Compare with existing patterns in the project

## Design
Inspiration: Apple, Stripe, Linear, Vercel
Styles: Glassmorphism (backdrop-filter, blur), gradients, dark mode ready
Typography: Inter, Outfit, Space Grotesk, `clamp()` for fluid sizing
Colors: CSS custom properties, contrast 4.5:1 (WCAG AA)

## Animations
```css
/* View Transitions */
.card { view-transition-name: card; }

/* Scroll-driven */
.section {
  animation: fade-in linear both;
  animation-timeline: view();
}
```

Hover effects on ALL interactive elements. 60fps. Respect reduced motion.

## Structure
- Hero: 100vh, clear CTA, visual wow
- Navigation: sticky, mobile hamburger -> fullscreen
- Sections: clear hierarchy, whitespace
- Footer: contact, social, copyright

## Graphics (no external images)
SVG icons, CSS art, Canvas/WebGL particles

## Checklist
- Wow factor present
- Consistent colors and typography
- View Transitions + Scroll-driven animations
- Hover effects everywhere
- Touch-friendly (44x44px)
- Zero console errors
- ARIA, contrast, dark mode
- Screenshot reference respected (if provided)
