---
trigger: always_on
description: When designing dialog appearance, focus styles, colors, typography, or layout for Kodi addon UI
---

# TV UI Design Constraints

When designing or modifying any dialog/window visual appearance, these constraints are mandatory.

## Authority
Skill `kodi-tv-designer` is the authoritative source for all visual design decisions. Always load it when working on dialog design.

## Hard Constraints

1. **Dark mode default** -- background `#0F0F0F`-`#1A1A1A`, never pure black or white
2. **Minimum text sizes** -- body 28px+, metadata 24px+, titles 48px+ (1080p)
3. **Focus state visibility** -- must be recognizable instantly from 3+ meters (border 3-5px, scale 1.05-1.23x, or glow)
4. **Safe zones** -- no important UI in outer 5% of screen, min 48px from edges
5. **Rule of 3 clicks** -- any content reachable in max 3 clicks from entry point
6. **Min focus area** -- 60x60px minimum for any focusable element

## Quick Check
Before any visual change, ask: "Is this readable from 3 meters? Is focus instantly visible?"