---
description: Development rules for Milionar addon -- load for any code work on this project
trigger: always_on
---

# Development Rules

## Communication Language
- **All plans and documentation ALWAYS in Czech language**
- **All `.agent/` config files (rules, skills, workflows) MUST be in English** -- LLM models process English instructions more accurately (see `config-standards.md`)

## Kodi Documentation
- [Kodi Wiki](https://kodi.wiki/view/Main_Page)
- [Kodi Python API](https://codedocs.xyz/xbmc/xbmc/)

## Addon Integrity and Stability
> **CRITICAL** -- This is a complex addon, always follow these principles:

- **Never break existing functionality** -- verify impact on the rest of the codebase before changes
- **Integrate new features completely** -- propagate to all relevant parts of the project
- **Do not delete working code** -- unless explicitly requested, do not remove existing functionality

## Code Quality
- **Consistency** -- follow existing code style in the project
- **Reusability** -- use existing functions and modules, never create duplicate code
- **Modularity** -- follow `modular-code.md` for architecture, `python-syntax.md` for syntax

## Forbidden
- Never use emojis
