---
trigger: model_decision
description: Debugging rules for Kodi addon -- log analysis and temporary debug output
---

## Kodi Log - macOS

**Log path:**
```
/Users/chudy/Library/Logs/kodi.log
```

---

## Debugging Procedure

### 1. Error Analysis
- Read last 100-200 lines of the log
- Look for `ERROR`, `WARNING` or traceback for `plugin.video.milionar`
- Identify exact cause of the error

### 2. Temporary Debug Logs
If you need more information, add debug output:

```python
import xbmc
xbmc.log(f"[DEBUG] description: {variable}", xbmc.LOGINFO)
```

**Rules for debug logs:**
- Prefix `[DEBUG]` for easy searching
- Descriptive messages about what is being measured/checked
- Log only relevant variables

### 3. Cleanup After Resolution
> **MANDATORY** - After fixing the error, ALWAYS remove all temporary debug logs you added.

- Search for `[DEBUG]` in modified files
- Delete all lines with temporary logs
- Keep only permanent logs that are part of production code

---

## Existing Logging in Project

Before adding your own logs, check existing logging infrastructure in the project and use it if available.
