---
trigger: model_decision
description: When generating images/textures for Kodi addon
---

# Image Generation for Kodi

When generating graphics for Kodi addon:

## Graphics Types

### 1. Textures and Masks (programmatic)
Use skill `kodi-texture-generator`:
- Rounded corners, pill shapes
- Scrollbars, progress bars
- Geometric UI elements

### 2. Icons and Images (generated)
Use skill `kodi-image-generator`:
- Addon icons
- Backgrounds, banners
- Decorative graphics

## Resolutions for Kodi
- Icons: 256x256 or 512x512 PNG
- Textures: powers of 2 (64, 128, 256...)
- Backgrounds: 1920x1080 or 3840x2160

## Formats
- PNG for transparent graphics
- JPG for photos without transparency
- No WebP (limited Kodi support)

## Paths
- `resources/media/` -- textures and images
- `resources/icon.png` -- main addon icon
- `resources/fanart.jpg` -- addon background
