#!/usr/bin/env python3
"""Generate provider icons for search dialog (webshare.cz, kra.sk)."""
from PIL import Image, ImageDraw, ImageFont
import os

SCRIPT_DIR = os.path.dirname(os.path.abspath(__file__))

# Icon size 32x32 rendered at 4x for antialiasing
SIZE = 32
SCALE = 4
S = SIZE * SCALE


def generate_webshare_icon():
    """Webshare icon: rounded square with 'W' letter shape."""
    img = Image.new('RGBA', (S, S), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    
    # Rounded square background
    radius = S // 5
    draw.rounded_rectangle(
        [(0, 0), (S - 1, S - 1)],
        radius=radius,
        fill=(255, 255, 255, 255)
    )
    
    # Cut out "W" shape using transparent drawing
    # Simple W using lines
    margin = S // 5
    top = margin
    bottom = S - margin
    mid_y = top + (bottom - top) * 3 // 4
    
    # W shape points
    w_points = [
        (margin, top),
        (margin + S // 8, bottom),
        (S // 2, mid_y),
        (S - margin - S // 8, bottom),
        (S - margin, top),
    ]
    
    # Draw W with transparent color (cut-out effect)
    draw.line(w_points, fill=(0, 0, 0, 0), width=S // 8)
    
    img = img.resize((SIZE, SIZE), Image.LANCZOS)
    output = os.path.join(SCRIPT_DIR, 'icon_provider_webshare.png')
    img.save(output, 'PNG')
    print(f'Generated: {output}')


def generate_kraska_icon():
    """KRA.sk icon: rounded square with 'K' letter shape."""
    img = Image.new('RGBA', (S, S), (0, 0, 0, 0))
    draw = ImageDraw.Draw(img)
    
    # Rounded square background
    radius = S // 5
    draw.rounded_rectangle(
        [(0, 0), (S - 1, S - 1)],
        radius=radius,
        fill=(255, 255, 255, 255)
    )
    
    img = img.resize((SIZE, SIZE), Image.LANCZOS)
    output = os.path.join(SCRIPT_DIR, 'icon_provider_kraska.png')
    img.save(output, 'PNG')
    print(f'Generated: {output}')


generate_webshare_icon()
generate_kraska_icon()
print('Done!')
