TV UI/UX Architect - Expert...

January 16th, 2026

TV UI/UX Architect - Expert na design pro velké obrazovky

Vítejte u kompletního průvodce návrhem uživatelských rozhraní pro televizní obrazovky. Tento materiál pokrývá všechny klíčové principy designu multimediálních center ve stylu Netflixu, Apple TV a dalších moderních streamovacích platforem.

Úvod do TV UI designu

Než se ponoříme do detailů, je důležité pochopit základní rozdíly mezi designem pro televizi a designem pro mobilní zařízení nebo desktop. Televize není jen větší obrazovka. Je to úplně jiný kontext použití, který vyžaduje fundamentálně odlišný přístup.

Kdy použít tento skill

Tento skill použijeme při návrhu jakéhokoliv uživatelského rozhraní pro televizní obrazovky. Hodí se pro design streamovacích platforem a media centerů. Využijeme ho při optimalizaci navigace pro dálkový ovladač. Pomůže nám při řešení focus states a vizuálního feedbacku. Použijeme ho při plánování layoutů pro vzdálenost sledování tři až deset metrů. A samozřejmě při jakékoli konzultaci ohledně best practices pro televizní uživatelskou zkušenost.

KRITICKÁ PRAVIDLA - Desetistopová zkušenost

Realita vzdálenosti sledování

Základní pravda, kterou musíme mít neustále na paměti: uživatel sedí tři až deset metrů, tedy deset až třicet stop, od obrazovky. Toto má zásadní důsledky pro náš design.

Text a UI elementy musí být výrazně větší než na mobilu nebo desktopu. Minimum je dvacet čtyři bodů pro běžný text a třicet šest bodů a více pro nadpisy. Kontrast je kritický - musíme testovat vždy při reálném osvětlení. Žádné detaily o velikosti jednoho pixelu - ty jsou z dálky neviditelné. A maximum čtyřicet znaků na řádek pro zachování čitelnosti.

Mentalita lehkého pohodlí

Televize je pasivní zařízení na rozdíl od aktivního používání mobilního telefonu. Uživatel je relaxovaný, ne soustředěný. Jeho tolerance pro složitost je nižší než u jiných zařízení. Pozornost může být rozdělená - konverzace, občerstvení, další aktivity v místnosti. Interface absolutně nesmí vyžadovat mentální úsilí.

D-Pad navigace - absolutní zákon

Žádný touchscreen, žádná myš - pouze směrový kříž. Máme k dispozici šipky nahoru, dolů, vlevo, vpravo, plus tlačítko SELECT a tlačítko BACK. Každý element musí být dosažitelný pomocí těchto šesti tlačítek. Grid layout je povinný - musíme zajistit jasné směry navigace. Žádné diagonální nebo složité trajektorie pohybu.

FOCUS STATES - Nejdůležitější princip TV UI

Pravidlo vizuální dominance

Focus state je to, kde teďka uživatel je. Toto je možná nejdůležitější věta v celém tomto materiálu. Focus state musí být viditelný na první pohled.

Jak toho dosáhneme? Bold borderem o minimální tloušťce tři až pět pixelů. Výraznou změnou velikosti - scale jedna celá nula pět až jedna celá dvacet tři krát. Změnou barvy nebo kontrastu. Shadow nebo glow efektem. A parallax nebo mírnou animací.

Co je anti-pattern? Jemný světlý outline. Změna pouze barvy textu. A příliš subtilní animace.

Co je naopak best practice? Netflix používá zoom plus bílý border plus shadow. Apple TV používá scale jedna celá dvacet tři krát plus parallax plus separaci vrstev. YouTube TV používá tlustý barevný border plus scale.

Persistence focusu

Toto je kritické: pokud uživatel odvrátí pohled a vrátí se zpět, musí okamžitě vědět, kde je focus.

Jak to vyřešíme? Focus state má mít přechod delší než dvě stě milisekund. Použijeme barvy s vysokým kontrastem vůči pozadí. V dark mode použijeme světlé focus bordery. V light mode použijeme tmavé focus bordery.

Flow focusu - navigační síť

Každý focusable element musí mít definováno: onUp - kam skočí focus při šipce nahoru. onDown - kam skočí focus při šipce dolů. onLeft - kam skočí focus při šipce vlevo. A onRight - kam skočí focus při šipce vpravo.

Prevence pastí: žádné slepé uličky - místa, odkud nejde vyskočit. Horizontální scrollery musí mít možnost úniku pomocí šipky nahoru nebo dolů. A zpět tlačítko musí být vždy funkční.

LAYOUT PRINCIPY

Bezpečné zóny - overscan

Nikdy neumísťujeme důležité UI do vnějších pěti procent obrazovky. Proč? Kvůli overscanu, který může části obrazovky ořezat.

Představme si to vizuálně: vnější okraj pět procent je nebezpečná zóna. Vnitřní plocha devadesát procent je safe zone pro text a UI. Důležité elementy umísťujeme minimálně čtyřicet osm pixelů od kraje.

Grid-based layout

Struktura je povinná: vertical scrolling znamená LIST container. Horizontal scrolling znamená SHELF nebo CAROUSEL. A 2D browsing znamená GRID nebo PANEL.

Co se týče spacingu: minimum dvacet pixelů mezi elementy, scaled podle velikosti televize. Generous white space vytváří profesionální dojem z dálky.

Content-first design

Hierarchie je jasná: obsah, tedy thumbnails a postery, zabírá sedmdesát procent prostoru. Metadata jako titulky a popisy zabírají dvacet procent prostoru. A UI controls, tedy tlačítka a menu, zabírají pouze deset procent prostoru.

Netflix princip říká: rozhraní je prostředek, ne cíl. Uživatel chce najít, co chce sledovat - a to rychle. Pustit si to - a to okamžitě. Ne procházet komplikovaná menu.

NAVIGAČNÍ PATTERNS

Top-level navigace

Existují dva hlavní styly.

První je sidebar, tradiční přístup. Máme vertikální menu vlevo. Šipka vlevo z libovolného místa vede do sidebaru. Je to rychlý přístup a funguje to pro nekonečný scroll.

Druhý je top bar, moderní přístup používaný Netflixem v roce dvacet dvacet pět a Apple TV. Máme horizontální menu nahoře. Šipka nahoru z libovolného místa vede do top menu. Je to čistší vzhled a máme definovaný začátek i konec stránky.

Design karuselu nebo police

Horizontální scroller s obsahem má povinné prvky: nadpis kategorie, například “Trending Now” nebo “Continue Watching”. Pět až sedm viditelných položek najednou. Smooth horizontal scroll. A šipka nahoru nebo dolů znamená skok mezi řadami karuselů.

Focus behavior funguje tak, že focused položka v řadě má zoom nebo highlight efekt. Ostatní řady zůstávají v normálním stavu. A přechod mezi řadami je plynulý.

Ekonomika kliknutí

Každý klik má cenu. Průměrný uživatel stráví dvacet pět plus minut browsováním, než začne sledovat. Click exhaustion vede k opuštění aplikace.

Jak to vyřešit? Fixed focus plus pull content, ne push focus. Auto-play trailers při hoveru, jak to dělá Netflix. Instant info expansion při focusu. A automatické přeskakování intrák a titulků.

COLOR & CONTRAST

Dark mode first

Televize znamená primárně dark UI. Proč? Zlepšuje to kontrast s jasným obsahem jako jsou videa a postery. Snižuje to únavu očí v tmavém pokoji. Vytváří to moderní, prémiový vzhled. A zdůrazňuje to obsah, ne rozhraní.

Jaká je správná paleta? Background používá odstíny nula F nula F nula F až jedna A jedna A jedna A - ne čistou černou! Text primary používá E nula E nula E nula - ne bílou FFFFFF, která je příliš ostrá. Text secondary používá A nula A nula A nula. A akcenty používají branding color, například Netflix red nebo Disney plus blue.

Pravidla kontrastu

WCAG AAA standard je minimum. Text ku pozadí má mít poměr sedm ku jedné. UI elementy mají mít poměr čtyři celá pět ku jedné. A focus indikátor má mít maximální kontrast, často bílá na tmavé.

Co je anti-pattern? Čistě bílé pozadí, které bolí oči v tmě. Příliš zářivé barvy, které vypadají přesyceně na TV. A jemné šedé tóny, které jsou neviditelné z dálky.

Povědomí o barevném gamutu

TV displeje mají rozdílný color gamut než PC monitory. Barvy vypadají saturovanější. Preferujeme chladnější tóny jako modrá a šedá nad teplými jako červená a oranžová. A testujeme na reálném TV, ne jen na monitoru.

TYPOGRAFIE

Škála velikostí pro tisíc osmdesát p televizi

Minimální velikosti jsou: body text dvacet osm pixelů a více, ekvivalent zhruba čtrnácti sp. Metadata dvacet čtyři pixelů a více, například rok vydání nebo žánr. Titulky čtyřicet osm až sedmdesát dva pixelů. A hero titulky devadesát šest až sto dvacet pixelů.

Pro 4K televizi tyto hodnoty vynásobíme jedna celá pět až dvakrát.

Výběr fontů

Sans-serif pouze. Proč? Lepší čitelnost z dálky a moderní, čistý look.

Příklady dobrých fontů: Netflix Sans, který je proprietární. Roboto, což je Android TV default. A SF Pro, používané Apple TV.

Co nikdy nepoužít? Serif fonty kvůli špatné čitelnosti. Kurzívu, která je rozmazaná z dálky. A light weight, který je neviditelný.

Délka řádku

Maximum čtyřicet znaků na řádek. Delší text způsobuje ztrátu orientace z dálky. A multi-line popisky by měly mít maximálně dva až tři řádky.

PERFORMANCE & SMOOTHNESS

Priorita frame rate

Šedesát snímků za sekundu je povinné. TV má pomalejší refresh než mobil. Trhané animace působí amatérsky. A smooth scroll vytváří premium zkušenost.

Jak optimalizovat? Preload content mimo viewport. Lazy load images při scrollu. Throttle animation updates. A GPU acceleration pro všechny přechody.

Stavy načítání

Nikdy prázdná obrazovka. Místo toho skeleton screens pro načítání. Placeholder thumbnails. Progress indikátory pro dlouhé operace. A “Continue Watching” s instant zobrazením.

CONTENT DISCOVERY

Personalizace

Moderní standard zahrnuje: Continue Watching jako top prioritu. Algoritmická doporučení. Trending a Popular sekce. A procházení podle žánrů a kategorií.

Netflix pattern vypadá takto: první je Hero nebo Featured, velký banner. Druhý je Continue Watching. Třetí je Trending Now. Čtvrtý je Because You Watched X. Pátý je New Releases. A pak pokračuje infinite scroll.

Search zkušenost

Optimalizace pro dálkový ovladač znamená: voice search pomocí Alexa, Google nebo Siri je lepší než klávesnice. Predictive suggestions po dvou až třech znacích. Recent searches. A quick filtry podle žánru, roku a ratingu.

Keyboard layout: qwerty je lepší než alfabetický. Velká tlačítka s minimální focus area šedesát krát šedesát pixelů. A auto-suggestions prominentně.

ACCESSIBILITY

Není volitelné

Co musí být implementováno? High contrast mode. Text-to-speech support s popisky všech UI elementů. Closed captions a subtitles jako defaultní možnost. Audio descriptions pro video obsah. A configurable text size.

Kontext více uživatelů

TV je sdílené zařízení. Proto potřebujeme user profiles pro děti a dospělé. Parental controls. Multiple watch histories. A separate recommendations pro každý profil.

ANTI-PATTERNS - co nikdy nedělat

Desktop a mobile myšlení

Nikdy neportujte web nebo mobile UI jedna ku jedné na TV. Nepoužívejte hover states - není tu myš. Nevytvářejte malé clickable areas. A nepředpokládejte touch gestures.

Informační přetížení

Příliš mnoho textu na obrazovce. Komplikované menu struktury. Deset a více options najednou. A vnořená sub-menu hlubší než dvě úrovně.

Špatná navigace

Focus traps. Nekonzistentní D-pad chování. Nejasné focus states. A příliš mnoho kroků k obsahu.

Performance problémy

Trhavý scroll pod šedesát snímků za sekundu. Pomalé načítání obrázků. Zpožděné focus transitions. A neodpovídající ovládací prvky.

PLATFORM SPECIFICS

Netflix best practices

Top menu bar je nový standard roku dvacet dvacet pět. Expandable cards při focus hover. Auto-play trailers po dvou až třech sekundách focusu. My List s prominentním umístěním. A content-forward přístup s minimem UI chrome.

Apple TV patterns

Parallax effect na focus s vrstvenými obrázky. Scale jedna celá dvacet tři krát zoom při focusu. Tab bar translucent style. Lockups - kombinované view elementy. A SF Pro font pro čistou typografii.

Android TV guidelines

Využití Leanback library. Material Design adaptace pro TV. Browse fragments struktura. A recommendations row na home screenu.

TESTING CHECKLIST

Povinné testy

View ze tří metrů, pěti metrů a osmi metrů distance. Tmavý pokoj versus osvětlený. Různé TV brandy jako Samsung, LG a Sony. Tisíc osmdesát p a 4K rezoluce. Standard a HDR režimy. A real user testing s dálkovým ovladačem.

Metriky ke sledování

Time to First Interaction pod tři sekundy. Navigation clicks to content pod pět. Focus state clarity s instant recognition. Scroll smoothness solidních šedesát fps. A content discovery success rate.

ZLATÁ PRAVIDLA na závěr

Prvně: FOCUS STATE je králem - vždy viditelný, vždy jasný.

Druhé: Content je důležitější než UI - rozhraní je služebník, ne hvězda.

Třetí: Simplicity wins - každý extra klik znamená ztrátu uživatele.

Čtvrté: Test na real TV - monitor nelže pravdu o čitelnosti.

Páté: Šedesát fps or bust - trhané animace jsou amatérské.

Šesté: Dark mode default - TV je pro relaxaci.

Sedmé: Pravidlo tří kliků - obsah maximálně tři kliky od home.

Osmé: D-pad first - navrhuj pro směrový kříž, ne pro myš.

Deváté: Scale everything dvakrát - co funguje na mobilu, je na TV malé.

A desáté: Consistent experience - stejné chování vytváří důvěru uživatele.

Při návrhu vždy začni otázkami

Je to čitelné ze tří a více metrů? Je focus state okamžitě viditelný? Dokáže to uživatel ovládat pouze D-padem? Je to jednoduché a intuitivní? A dostane se k obsahu do tří kliků?

Pokud na cokoli odpovíme ne - je čas na redesign.

Pamatujte si: “Nejlepší TV interface je ten, kterého si nevšimnete - protože sledujete obsah.”

To je konec tohoto průvodce návrhem televizních rozhraní. Děkuji za pozornost.​​​​​​​​​​​​​​​​