---
description: Explore, learn and analyze project functionality or its specific parts
---

# /learn

Syntax: see `workflow-syntax.md` -- scope: component/description/screenshot, `/do` = create report without asking

## Purpose
Deep exploration and understanding of the project, its parts, or visual design.

## Input Modes

### 1. Text Input
- `/learn` -- entire project
- `/learn [component]` -- specific part (e.g. `wheel-picker`)
- `/learn [description]` -- agent finds relevant files

### 2. Screenshot Input
- `/learn` + screenshot(s) -- understand visual design and find/create implementation
- `/learn` + screenshot without text -- analyze what you see, identify in project

## Screenshot Analysis

ALWAYS analyze screenshot as **iPhone PWA in standalone mode**:

1. **Identify elements:**
   - Layout (flex/grid, direction, alignment)
   - Components (buttons, cards, modals, inputs)
   - Typography (size, weight, color)
   - Colors (background, text, accents)
   - Spacing (gap, padding, margin)
   - Shadows, border-radius, effects

2. **Be PRECISE:**
   - Every pixel matters
   - Notice details (1px border, subtle shadows)
   - Compare with existing project design

3. **Based on context:**
   - **Understanding**: Find corresponding code in project
   - **Replication**: Create new code based on screenshot
   - **Combination**: Understand existing + add missing

## Behavior
- `/learn` -- explores, asks what next
- `/learn /do` -- explores + creates report
- `/learn` + screenshot -- analyzes, asks about intent
- `/learn` + screenshot `/do` -- analyzes + implements

## Procedure

### 1. Determine Input Type
- Text -> search in codebase
- Screenshot -> analyze visual
- Combination -> connect both

### 2. Explore/Analyze
**Text input:**
- `list_dir`, `view_file_outline`
- `.agent/rules/`, `docs/`
- Dependencies and flow

**Screenshot input:**
- Detailed visual analysis
- Comparison with existing components
- Identify CSS patterns

### 3. Connect with Project
- Find corresponding files
- Identify existing patterns
- Determine what exists vs. what's missing

### 4. Output
- With `/do`: Report to `docs/knowledge/[name].md`
- Without `/do`: Summarize findings, ask what next
- Screenshot: Propose implementation or describe found code

## Report Format
```
# Knowledge: [Name]
**Created**: [YYYY-MM-DD HH:mm]
**Scope**: [what was explored]
**Source**: [text/screenshot/combination]

## Purpose
## Files
## Main Functions/Visual Elements
## Flow (mermaid)
## Dependencies
## Notes
```

## Combinations
- `/learn /do` -- explore + report
- `/learn /analyze` -- explore + problem analysis
- `/learn /audit` -- explore + quality audit
