---
description: Create or update documentation for a completed/in-progress feature
---

# /feature

Syntax: see `workflow-syntax.md` -- scope: feature name/description, `/do` = create without asking

## Detection Mode
- Active document in `docs/features/*.md` -> UPDATE
- Otherwise -> CREATE

## Interactive Start (without `/do`)
Ask:
- Feature name
- Status (completed/in-progress)
- Brief description (1 sentence)

## Documentation Contains
- Name, Status (COMPLETED/IN_PROGRESS/PLANNED)
- Created/updated date
- Purpose -- what the feature does
- How it works -- basic principle
- Key components -- files and their roles
- How to use/extend
- Dependencies
- Implementation notes
- TODO (for IN_PROGRESS)

## Does NOT Contain
- Full source code
- Overly technical details
- Speculation

## Procedure: CREATE
1. Ask user (without `/do`)
2. Check `docs/features/` for next index
3. Name `[XXX]-[name].md` (kebab-case)
4. Analyze relevant code
5. Create documentation

## Procedure: UPDATE
1. Read active document
2. Update based on dialog
3. Add `## Updated: [YYYY-MM-DD HH:mm]`
4. Update TODO section
