---
name: responsive-design
description: Responsive design for desktop, tablet, and mobile. Use for landing pages and web documentation.
trigger: responsive, mobile first, breakpoints, tablet, desktop, mobile, touch, container query, fluid, clamp, viewport, media query
---

# Responsive Design

Fully responsive websites with mobile-first approach.

## Mobile-First
ALWAYS start from mobile (320px). Base styles without media queries = mobile.

## Breakpoints
| Breakpoint | Min-width | Device |
|------------|-----------|--------|
| Base | 0px | Mobile |
| sm | 640px | Mobile landscape |
| md | 768px | Tablet |
| lg | 1024px | Desktop |
| xl | 1280px | Large screens |

```css
.element { /* base = mobile */ }
@media (min-width: 640px) { .element { /* sm */ } }
@media (min-width: 768px) { .element { /* md */ } }
@media (min-width: 1024px) { .element { /* lg */ } }
```

## Container Queries
Components react to parent, not viewport.
```css
.card-container { container-type: inline-size; }
@container (min-width: 400px) {
  .card { display: grid; grid-template-columns: 1fr 2fr; }
}
```
Units: `cqi` = 1% inline size, `cqw`, `cqh`, `cqmin`, `cqmax`

## Fluid Typography
```css
:root {
  --font-base: clamp(1rem, 0.9rem + 0.5vw, 1.25rem);
  --font-lg: clamp(1.25rem, 1rem + 1vw, 2rem);
  --font-xl: clamp(1.5rem, 1rem + 2vw, 3rem);
}
```

## Fluid Spacing
```css
:root {
  --space-sm: clamp(0.5rem, 0.4rem + 0.5vw, 1rem);
  --space-md: clamp(1rem, 0.8rem + 1vw, 2rem);
  --space-lg: clamp(2rem, 1.5rem + 2vw, 4rem);
}
```

## Devices
- Mobile: single column, touch 44x44px, hamburger menu
- Tablet: multi-column, touch-friendly, both orientations
- Desktop: hover effects, wide layouts, sticky nav, keyboard nav

## Checklist
- Mobile-first approach
- Fluid typography (`clamp()`)
- Container Queries for components
- Touch buttons min 44x44px
- No horizontal scroll
- Hover effects on desktop
