---
trigger: model_decision
description: Use for mysterious Python errors that make no sense (ImportError, wrong traceback lines, broken import after rename)
---

# Clear __pycache__ & Texture Cache

For mysterious Python errors (ImportError, mismatched traceback, weird behavior after refactoring) -- delete cache:

```bash
find . -type d -name "__pycache__" -exec rm -rf {} + 2>/dev/null
```

Run from addon root.

For stale/broken images or textures -- delete Kodi texture cache:

```bash
rm -f "$HOME/Library/Application Support/Kodi/userdata/Database/Textures13.db"
rm -rf "$HOME/Library/Application Support/Kodi/userdata/Thumbnails"
```

After any of the above, restart Kodi.
