# 007 - MyTV Dialog

**Status:** COMPLETED
**Vytvoreno:** 2026-02-08 21:20
**Soubory:** `wcs/ai/DialogMyTV.py`, `resources/skins/Default/1080i/ai/DialogMyTV.xml`

---

## Ucel

MyTV je hlavni televizni rozhrani addonu -- umoznuje uzivateli vytvaret vlastni "kanaly" ze serialu, sledovat automaticky generovany program a spoustet prehravani. Kombinuje TV guide UX s AI-driven doporucenim obsahu.

---

## Jak to funguje

### Zakladni princip

1. Uzivatel vytvori **kanal** a prida do nej serialy
2. System automaticky generuje **program** (seznam epizod) podle sledovaci historie
3. Uzivatel muze spustit **vysilani** (playlist), prehrat konkretni epizodu, nebo zamichat program
4. **ChannelHistory** sleduje progress kazdeho serialu per-kanal (sezona/epizoda)

### Tok dat

```
MediaChannelManager (kanaly, serialy)
        |
        v
DialogMyTV.py (logika, UI orchestrace)
        |
        +-- ChannelHistory (progress per-kanal)
        +-- TMDb API (metadata, postery, fanart)
        +-- CacheManager (obrazky, metadata)
        |
        v
DialogMyTV.xml (layout, animace, navigace)
```

---

## Klicove komponenty

### Python logika

| Soubor | Ucel |
|--------|------|
| [DialogMyTV.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/DialogMyTV.py) | Hlavni dialog trida `MyTVDialog` (64 metod, ~2500 radku) |
| [MediaChannelManager.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/MediaChannelManager.py) | Sprava kanalu, serialu, composite ikon |
| [ChannelHistory.py](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/wcs/ai/ChannelHistory.py) | Per-channel JSON historie sledovani |

### XML layout

| Soubor | Ucel |
|--------|------|
| [DialogMyTV.xml](file:///Users/chudy/Library/Application%20Support/Kodi/addons/plugin.video.milionar/resources/skins/Default/1080i/ai/DialogMyTV.xml) | WindowXML layout (~2880 radku) |

---

## Architektura UI

### Hlavni obrazovka

```
+------------------------------------------------------------------+
|  [Gradient shora]                                                |
|  Titulek (MyTV - televize budoucnosti)        Hodiny  21:09      |
|  Statistiky kanalu (1 kanal / 5 serialu)      Nedele, 8.2.2026  |
|  Obsah kanalu: Komedie                   [Spustit] [Zamichat]   |
|                                              [Smazat kanal]      |
+------------------------------------------------------------------+
|  [Series Grid 9100]    |  [Program List 9000]                    |
|  +----+----+----+      |  +--+----------------------------+---+  |
|  |Poster1|Poster2|     |  |Th| Serial S01E02             |25m|  |
|  +----+----+----+      |  |  | Nazev epizody             |   |  |
|  |Poster3|  +   |      |  |  | Popis...                  |   |  |
|  +----+--------+       |  +--+----------------------------+---+  |
|                         |  |Th| Serial S01E03             |21m|  |
|                         |  +--+----------------------------+---+  |
+------------------------------------------------------------------+
|  [Channel List 2000 - horizontalni wraplist dole]                |
|  [Poster+] [Kanal1] [Kanal2] [Kanal3] [+Novy]                   |
+------------------------------------------------------------------+
```

### XML Control IDs

| ID | Typ | Ucel |
|----|-----|------|
| 2000 | list | Seznam kanalu (dole) |
| 9000 | list | Program list (prava strana) |
| 9010 | scrollbar | Scrollbar pro program list |
| 9100 | panel | Series grid (leva strana -- postery serialu) |
| 9099 | grouplist | Action buttons (Spustit/Zamichat/Smazat) |
| 9004 | button | Spustit vysilani |
| 9005 | button | Zamichat |
| 9003 | button | Smazat kanal |
| 9006 | button | Potvrdit smazani |
| 7000 | group | Navigation sidebar |
| 7100 | list | Sidebar polozky |
| 7200 | list | Sidebar header |

### Sub-dialogy (inline)

| ID rozsah | Ucel |
|-----------|------|
| 5000-5501 | Add Series dialog (vyhledavani, vysledky, pridani serialu) |
| 9200-9250 | Series Detail dialog (info o serialu, sezony, epizody) |
| 9300-9305 | Play Selection dialog (volba prehravani) |
| 3000-3001 | Search edit + button |
| 4000-4001 | Vysledky vyhledavani |
| 1000-1002 | Text description + scrollbar |

---

## Background system

### 6 rezimu pozadi

| Mode | Nazev | Zdroj |
|------|-------|-------|
| 0 | Staticke | `hub_background_v2.png` |
| 1 | Fanart serialu | `Container(9000).ListItem.Art(fanart)` |
| 2 | Still epizody | `Container(9000).ListItem.Art(thumb)` |
| 3 | Kolaz posteru | PIL -- 2x2 grid z posteru |
| 4 | Kolaz stillu | PIL -- grid ze stillu epizod |
| 5 | Mix kolaz | PIL -- kreativni layout |

### Ken Burns animace

5 stylu animace (zoom + slide kombinace):

| Styl | Efekt | Perioda |
|------|-------|---------|
| Jemny dech | Zoom 106% + drift | 45s |
| Pulzujici srdce | Zoom 150% | 30s |
| Plynouci tok | Horizontal slide | 50s |
| Dynamicka vlna | Zoom 115% + diagonal | 25s |
| Zrcadlovy odraz | Zoom 108% + opposite | 40s |

### Overlay vrstvy

1. **Matte layer** -- tmave pozadi `#0A0A0F` (vzdy viditelne jako zaklad)
2. **Background** -- zvolen rezim (fade-in pres matte)
3. **Dynamic dimming** -- konfigurovatelne ztmaveni (0-90%)
4. **Gradient shora** -- `gradient_top_fade.png`, plynuly fade pro citelnost headeru

---

## Sprava kanalu

### MediaChannelManager

- Uklada kanaly do `user_data` (JSON)
- Kazdy kanal: `id`, `name`, `icon`, `media_list` (seznam serialu)
- **Composite ikona** -- PIL generuje 2x2 grid z posteru serialu

### Operace

| Akce | Metoda |
|------|--------|
| Vytvorit kanal | `create_channel(name)` |
| Smazat kanal | `delete_channel(channel_id)` |
| Prejmenovat | `rename_channel(channel_id, new_name)` |
| Pridat/odebrat serial | `toggle_media_in_channel(channel_id, media_data)` |
| Nahodna epizoda | `get_random_episode_for_channel(channel_id)` |

### ChannelHistory

- Per-channel JSON soubory v userdata
- Pro TV: `{series_id: {"season": int, "episode": int}}`
- Automaticka migrace z globalni historie pri prvnim pouziti
- Funkce: `update_series_progress()`, `get_series_progress()`

---

## Program list

### Generovani programu

1. `refresh_program_view()` -- debounced trigger (300ms delay)
2. `_instant_load_from_cache()` -- okamzite naplneni z cache
3. `_async_program_load()` -- background thread nacte data z TMDb
4. `_add_single_program_item()` -- progressive loading (po jednom)
5. `_save_program_list_cache()` -- ulozi do cache

### Polozka programu

Kazdy item v program listu zobrazuje:
- **Thumbnail** (still epizody) se zaoblenymi rohy
- **Logo serialu** (overlay dole na stillu)
- **Nazev serialu** + cislo epizody (S01E02)
- **Nazev epizody** + zkraceny plot
- **Runtime** (vpravo)

### Focus layout

Pri focusu se zobrazi:
- Glow pozadi (`list_focus_rounded.png`)
- Zvyraznene barvy textu
- Animace

---

## Prehravani

### 3 rezimy

| Rezim | Metoda | Popis |
|-------|--------|-------|
| Spustit vysilani | `_play_broadcast()` | Playlist vsech polozek v programu |
| Prehrat serial | `_play_series_only()` | Jen epizody vybraneho serialu |
| Prehrat od pozice | `_play_channel_from_selected()` | Od vybraneho mista + generuje dalsi |

### Playlist

- Vytvori `xbmc.PlayList(PLAYLIST_VIDEO)`
- Kazda polozka = plugin URL s `action=play_episode_from_addon_playlist`
- Metadata: titulek, plot, rating, poster, fanart, sezona, epizoda
- Sleduje `mytv_channel_id` pro aktualizaci historie

---

## Sub-dialogy

### Add Series dialog (5000)

- Vyhledavani serialu pres TMDb
- Vysledky v listu s postery a nazvy
- Toggle pridani/odebrani z kanalu
- Po zavreni: automaticke AI pojmenovani kanalu

### Series Detail dialog (9200)

- Detail serialu: fanart, poster, metadata
- Navigace: sezony (wraplist 9211) → epizody (list 9220)
- Akce: Prehrat serial, Prehrat epizodu, Smazat serial, Zavrit
- TMDb metadata s cache

### Play Selection dialog (9300)

- Vyber typu prehravani po kliknuti na epizodu
- Tlacitka: Prehrat epizodu, Prehrat serial, Prehrat kanal od teto pozice, Zamichat kanal

### Delete Confirmation

- Inline potvrzeni smazani kanalu
- Pill background s textem + Potvrdit tlacitko

---

## Navigace

### Focus flow

```
Action Buttons (9004/9005/9003)
        |
        v
Series Grid (9100) <---> Program List (9000)
        |                       |
        v                       v
Channel List (2000)      Scrollbar (9010)
```

### Sidebar (7000)

- Navigacni menu s polozkami (Home, MyTV, MyCinema, atd.)
- Otevirani pres `_show_nav_sidebar()` / `_hide_nav_sidebar()`
- Gradient edge na pravem okraji sidebaru

---

## Toast notifikace

- Vlastni implementace pres window properties
- Typy: `info`, `success`, `warning`, `error`
- Automaticky zmizi po nastavenem case (default 3s)
- Pozice: pravy horni roh

---

## Nastaveni

Konfigurovatelne pres `addon.getSetting()`:

| Setting ID | Typ | Popis |
|------------|-----|-------|
| `mytv_background_mode` | text | Rezim pozadi (6 moznosti) |
| `mytv_background_dim` | int | Uroven ztmaveni (0-90%) |
| `mytv_background_animation` | bool | Ken Burns animace |
| `mytv_anim_style` | text | Styl animace (5 moznosti) |

---

## Jak rozsirit

### Pridat novy background rezim

1. Pridat konstantu `BG_*` v `MyTVDialog`
2. Pridat polozku do `mode_map` v `_setup_background_properties()`
3. Pridat XML control s `visible` condition v BACKGROUND LAYER
4. Implementovat generovani v `_generate_background_async()`

### Pridat novou akci

1. Pridat button XML s unikatnim ID
2. Pridat handler v `onClick()`
3. Pridat navigaci (`onup`/`ondown`/`onleft`/`onright`)

### Pridat novy sub-dialog

1. Pridat XML group s `visible` condition na window property
2. Pridat `_show_*_dialog()` / `_close_*_dialog()` metody
3. Pridat `_handle_*_action()` / `_handle_*_click()` delegaci

---

## Zavislosti

- `wcs.ai.MediaChannelManager` -- sprava kanalu
- `wcs.ai.ChannelHistory` -- historie sledovani
- `wcs.ai.DialogAIChatRecommendation` -- AI doporuceni
- `wcs.library.LibraryManager` -- knihovna serialu
- `wcs.utils.cache_manager` -- centralizovany cache
- PIL/Pillow (volitelne) -- kolaze, efekty pozadi
- TMDb API -- metadata, postery, fanart

---

## Implementacni poznamky

- **Focus management**: `defaultcontrol` je zakazany -- focus se nastavuje Pythonem po nacteni dat
- **Debouncing**: Program list se nacita s 300ms debounce pro eliminaci zbytecnych API volani
- **Progressive loading**: Polozky programu se pridavaji po jednom pro plynuly UX
- **Cache**: Program list se uklada do cache pro okamzite zobrazeni pri navratu
- **Background thread**: Obrazky pozadi a PIL efekty se generuji na pozadi -- UI nikdy neblokuje
- **State cleanup**: `onInit` resetuje vsechny properties aby se zabranilo flash efektum z predchozi session
