---
description: Create or update an issue document describing a problem
---

# /issue

Syntax: see `workflow-syntax.md` -- scope: problem description, `/do` = create without asking

## Detection Mode
- Active document in `docs/issues/*.md` -> UPDATE
- Otherwise -> CREATE

## Issue Contains
- Problem name
- Status: OPEN / IN_PROGRESS / RESOLVED / CLOSED
- Created (and updated) date
- Problem description
- Steps to reproduce
- Expected vs. actual behavior
- Technical details (ONLY verified ones)

## Does NOT Contain
- Solution proposals
- Root cause analysis
- Code speculation
- Files/functions you haven't seen

## Format
```
# Issue: [Name]
## Status: OPEN
## Created: [YYYY-MM-DD HH:mm]

## Problem
[description]

## Reproduction
1. [steps]

## Expected Behavior
[what should happen]

## Actual Behavior
[what happens]
```

## Procedure: CREATE
1. Check `docs/issues/` for next index
2. Name `[XXX]-[name].md`
3. Summarize problem from dialog
4. DO NOT COMBINE with solution

## Procedure: UPDATE
1. Read active document
2. Update based on dialog
3. Add `## Updated: [YYYY-MM-DD HH:mm]`