---
description: Debug session - adds logs to Python code for monitoring in Kodi log
---

# /debug

Syntax: `/debug [component/problem description]`

Agent adds diagnostic logs, does NOT launch Kodi.

## Problem Source
- Primary: current dialog
- Secondary: `docs/issues/*.md`

## Steps

### 1. Identify Locations for Logs
- Which Python files are relevant
- Which functions to monitor
- What values to log

### 2. Add Diagnostic Logs
```python
# DEBUG: [description]
import xbmc
xbmc.log('[Component] [function]: [message]', xbmc.LOGINFO)
xbmc.log(f'[Component] state: {variable}', xbmc.LOGINFO)
```

Rules:
- Component name and function in prefix
- Log function inputs/outputs
- Use `xbmc.LOGINFO` for debug

### 3. Instructions for User
```
Debug session ready!
1. Restart Kodi
2. Reproduce the problem
3. Open kodi.log:
   - macOS: ~/Library/Logs/kodi.log
   - Windows: %APPDATA%\Kodi\kodi.log
   - Linux: ~/.kodi/temp/kodi.log
4. Filter: "[DEBUG]"
5. Send relevant part of the log
```

### 4. Wait for Feedback

### 5. After Fix WAIT for Confirmation
NEVER automatically remove logs.

### 6. Cleanup (after confirmation)
Remove lines containing "[DEBUG]"
