---
trigger: model_decision
description: When creating or modifying agent configuration — rules, skills, workflows in .agent/ folder
---

# Config Standards

When creating configuration ALWAYS:
- Use skill `config-creator`
- Check that a similar one doesn't already exist
- Follow the style of existing files

## Language Rule

> [!IMPORTANT]
> All `.agent/` configuration files (rules, skills, workflows) MUST be written in **English**.
> This ensures optimal LLM comprehension — training data is predominantly English.
> Communication with the user remains in Czech (per `czech-communication.md`).

## Structure
- Rule: `.agent/rules/[name].md`
- Skill: `.agent/skills/[name]/SKILL.md`
- Workflow: `.agent/workflows/[name].md`

## Required Elements

### Rule
- `trigger:` model_decision or explicit description
- `description:` English, when it activates

### Skill
- `name:`, `description:`, `trigger:`
- Role description in first person ("You are...")

### Workflow
- `description:` English
- Name starts with `/`
- Steps numbered

## FORBIDDEN
- Empty trigger/description
- TODO or placeholder
- Duplicate configuration
- Non-existent references
- Czech or other non-English text in config file contents
