# Stream Cinema Native Changelog

This changelog tracks native macOS migration progress for `StreamCinemaNative`.
Format: reverse chronological by date.

## 2026-02-06

### Added

1. Initial Swift package structure for native migration:
   - `StreamCinemaCore` library
   - `sc-cli` executable
   - `sc-desktop` executable
2. Core API clients and models:
   - kra login/session and file resolve
   - stream-cinema token and catalog requests
   - stream listing and playback URL resolve
3. Keychain persistence layer:
   - credentials
   - kra session token
   - stream-cinema auth token
4. Desktop app baseline:
   - login form
   - menu navigation
   - stream selection
   - playback panel
5. CLI diagnostics:
   - `menu`
   - `play`
   - `inspect` (stream metadata)
6. VLC fallback integration via `VLCKitSPM`:
   - automatic fallback when AVPlayer fails
   - manual `Play with VLC` button
7. Launcher script:
   - `StreamCinemaNative/run-sc-desktop`
   - sets `DYLD_FRAMEWORK_PATH` for direct binary launch

### Changed

1. Menu title mapping improved to resolve localized and nested title fields.
2. Playback view changed from SwiftUI `VideoPlayer` to native `AVPlayerView` bridge to avoid runtime crash.
3. Auth behavior updated for parity with Kodi-style token reuse:
   - desktop restores persisted tokens and refreshes only when needed
   - CLI reuses persisted tokens, refreshes and retries once on auth failure
4. Desktop request paths (`menu`, `stream list`, `resolve`) now auto-refresh auth on `401 authorization required` and retry once.

### Fixed

1. App window focus issue on launch (text fields not editable until activation fix).
2. Direct binary launch dyld error for `VLCKit.framework` (via launcher script).
3. `<no title>` in menu list for many entries.
4. Playback crash path previously triggered in SwiftUI `VideoPlayer`.

### Notes

1. First build after VLC integration downloads a large binary artifact (~780MB).
2. Some streams may still fail depending on provider/source/network constraints even with VLC fallback.
