#!/usr/bin/env python3
"""
Generování velkého zaobleného obdélníku pro dialog pozadí.
Radius 80px pro výrazné zaoblení rohů.
"""
from PIL import Image, ImageDraw

# Rozměry a radius
WIDTH, HEIGHT = 200, 200
RADIUS = 55  # Velký radius pro výrazné zaoblení
SCALE = 4    # Antialiasing

# Vytvoření obrazu ve vysokém rozlišení
img = Image.new('RGBA', (WIDTH * SCALE, HEIGHT * SCALE), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Zaoblený obdélník s velkým radiusem
draw.rounded_rectangle(
    [(0, 0), (WIDTH * SCALE - 1, HEIGHT * SCALE - 1)],
    radius=RADIUS * SCALE,
    fill=(255, 255, 255, 255)
)

# Downscale pro antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Uložení
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/dialog_rounded_large.png'
img.save(output_path, 'PNG')
print(f"Uloženo: {output_path}")
