# Provider API Testování

**Status:** COMPLETED  
**Vytvořeno:** 2026-02-06  

---

## Účel

Rychlé ověření dostupnosti a funkčnosti KRA.sk a Stream Cinema serverů bez spuštění Kodi.

---

## Aktuální tokeny

```bash
# Export pro použití v příkazech
export KRASKA_TOKEN="Gp4D6yoqn0bB"
export SC_TOKEN="f94c65dded9f1034ea1734eb9f050fea"
```

> **Pozor:** Tokeny expirují. Pokud testy selhávají s 401/403, je nutné se znovu přihlásit v Kodi a aktualizovat tokeny.

---

## Rychlý Health Check

### Ping test (síťová dostupnost)

```bash
# Stream Cinema
ping -c 2 stream-cinema.online

# KRA.sk
ping -c 2 api.kra.sk
```

### HTTP test (API dostupnost)

```bash
# Stream Cinema - rychlý test
curl -s -o /dev/null -w "SC API: %{http_code}\n" \
  -H "X-AUTH-TOKEN: $SC_TOKEN" \
  -H "User-Agent: Milionar/1.0 (Kodi)" \
  "https://stream-cinema.online/kodi/Search/search-movies?ver=2.0&uid=test&skin=milionar&lang=CS&HDR=1&DV=0&search=test&ms=1"
```

**HTTP kódy:**
- `200` - Server běží OK
- `503` - Server dočasně nedostupný (přetížený)
- `401/403` - Neplatný/expirovaný token
- `404` - Chybí auth header nebo špatný endpoint

---

## Kompletní testy

### 1. Stream Cinema - Vyhledání filmu

```bash
curl -s -w "\nHTTP: %{http_code}" \
  -H "X-AUTH-TOKEN: $SC_TOKEN" \
  -H "User-Agent: Milionar/1.0 (Kodi)" \
  "https://stream-cinema.online/kodi/Search/search-movies?ver=2.0&uid=test&skin=milionar&lang=CS&HDR=1&DV=0&search=Matrix&ms=1"
```

Očekávaná odpověď:
```json
{
  "menu": [
    { "title": "Matrix", "url": "/Play/m_xxx", ... }
  ]
}
```

### 2. Stream Cinema - Vyhledání seriálu

```bash
curl -s -w "\nHTTP: %{http_code}" \
  -H "X-AUTH-TOKEN: $SC_TOKEN" \
  -H "User-Agent: Milionar/1.0 (Kodi)" \
  "https://stream-cinema.online/kodi/Search/search-series?ver=2.0&uid=test&skin=milionar&lang=CS&HDR=1&DV=0&search=Pratele&ms=1&typ=2"
```

> **Kritické:** `typ=2` je povinný pro seriály!

### 3. KRA.sk - Ověření session

```bash
curl -s -w "\nHTTP: %{http_code}" \
  -H "Content-Type: application/json" \
  -X POST \
  -d '{"data":{"session_id":"'$KRASKA_TOKEN'"}}' \
  "https://api.kra.sk/api/user/info"
```

---

## Jednořádkový diagnostický skript

```bash
echo "=== Provider Health Check ===" && \
echo -n "Ping SC: " && ping -c 1 stream-cinema.online >/dev/null 2>&1 && echo "OK" || echo "FAIL" && \
echo -n "Ping KRA: " && ping -c 1 api.kra.sk >/dev/null 2>&1 && echo "OK" || echo "FAIL" && \
echo -n "SC API: " && curl -s -o /dev/null -w "%{http_code}\n" -H "X-AUTH-TOKEN: f94c65dded9f1034ea1734eb9f050fea" -H "User-Agent: Milionar/1.0" "https://stream-cinema.online/kodi/Search/search-movies?ver=2.0&uid=test&skin=milionar&lang=CS&HDR=1&DV=0&search=test&ms=1"
```

---

## Troubleshooting

| Symptom | Příčina | Řešení |
|---------|---------|--------|
| Ping OK, HTTP 503 | Server přetížený | Počkat 10-30 min |
| Ping OK, HTTP 401/403 | Expirovaný token | Znovu se přihlásit v Kodi |
| Ping FAIL | Síťový problém | Zkontrolovat internet |
| HTTP 404 bez headeru | Chybí X-AUTH-TOKEN | Přidat auth header |

---

## Kde najít nové tokeny

```bash
# macOS
grep -E "kraska_token|sc_auth_token" ~/Library/Application\ Support/Kodi/userdata/addon_data/plugin.video.milionar/settings.xml
```

