---
description: Audit codebase — hledá problémy, duplikace, neefektivity a návrhy k refaktoringu
---

# /audit

Syntaxe: viz `workflow-syntax.md` — scope: CSS/JS/komponenta, `/fix` = audit + oprava

## Režimy
- `/audit` — celá codebase
- `/audit CSS` nebo `/audit JS` — jen daná technologie
- `/audit [komponenta]` — konkrétní část

## Kontroluj podle
1. Pravidla v `.agent/rules/web-dev-standards.md`
2. Skill `tech-researcher` pro best practices
3. Skill `config-auditor` pro kontrolu rules/skills

## Kategorie nálezů
- DUPLICATE — duplikovaný kód (porušení DRY)
- INEFFICIENCY — neefektivní řešení
- BUG — potenciální chyba
- REFACTOR — návrh na refaktoring
- COMPATIBILITY — problém s kompatibilitou
- STRUCTURE — porušení struktury projektu

## Závažnost
- CRITICAL — musí se opravit (chyba, bezpečnost)
- WARNING — mělo by se opravit (neefektivita, duplikace)
- INFO — návrh ke zlepšení

## Postup
1. Analyzuj scope (celá codebase / technologie / část)
2. Použij skills: `tech-researcher`, `config-auditor`
3. Projdi soubory systematicky
4. Zaznamenej nálezy do `docs/audits/[XXX]-[nazev].md`
5. Vytvoř shrnutí `docs/audits/YYYY-MM-DD-summary.md`

## Formát nálezu
```
# Audit: [Název]
## Typ: [DUPLICATE/BUG/...]
## Závažnost: [CRITICAL/WARNING/INFO]
## Created: [YYYY-MM-DD HH:mm]

## Problém
[popis]

## Kde
- [soubor](file:///path) — řádky X-Y

## Proč je to problém
[dopad]

## Doporučené řešení
[návrh bez implementace]
```

## Pravidla
- Nenavrhuj řešení které jsi netestoval
- Odkazuj na existující patterns
- Použij `tech-researcher` pro ověření
