# StreamCinemaNative

This folder contains the first native migration foundation from the Kodi plugin:

- `StreamCinemaCore`: Swift client code for:
- `kra.sk` login/session and file resolve flow.
- `stream-cinema.online/kodi` token and catalog API flow.
- stream listing and final playback URL resolving.
- secure credential/session persistence in macOS Keychain.
- dual playback engines: `AVPlayer` primary + `VLCKit` fallback for problematic MKV streams.
- `sc-cli`: Small command-line runner for quickly verifying API and playback parity.
- `sc-desktop`: Minimal SwiftUI desktop shell (login/menu/stream select/play).

## Quick start

```bash
cd StreamCinemaNative
swift build
SC_USERNAME="your_kra_user" SC_PASSWORD="your_kra_pass" .build/debug/sc-cli menu /
SC_USERNAME="your_kra_user" SC_PASSWORD="your_kra_pass" .build/debug/sc-cli play /Play/<movie-id>
swift run sc-desktop
./run-sc-desktop
```

`sc-desktop` automatically restores credentials + tokens from Keychain on next launch.
If AVPlayer cannot play a stream, the app can switch to VLC fallback automatically and also exposes a `Play with VLC` button.
`sc-cli` now also reuses the same Keychain auth state and only re-authenticates when stored token/session no longer works.

Use `./run-sc-desktop` when launching the built binary directly. It sets `DYLD_FRAMEWORK_PATH` so `VLCKit.framework` is found correctly.

## Why this exists first

A 1:1 macOS app migration is easier and safer if backend behavior is extracted from Kodi UI first.
Once these API flows are stable, you can build a SwiftUI app on top without changing authentication and stream resolving logic.

## Handover doc

For full implementation status, architecture map, auth/token lifecycle, playback fallback behavior, and next-step roadmap, use:

- `docs/macos-native-migration.md`
- `docs/CHANGELOG-NATIVE.md`
