from PIL import Image, ImageDraw
import os

BASE_PATH = "/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media"

# Cards to fix (remove gold borders)
GOOD_CARD = "ai_card_movies.png"
BAD_CARDS = [
    "ai_card_series.png",
    "ai_card_actors.png",
    "ai_card_collections.png",
    "ai_card_history.png"
]

def fix_gold_borders():
    # 1. Get Reference Color from Good Card (Top Left)
    good_path = os.path.join(BASE_PATH, GOOD_CARD)
    with Image.open(good_path) as ref_img:
        ref_img = ref_img.convert("RGBA")
        # Sample pixel at top-center, safe from rounded corners
        bg_color = ref_img.getpixel((220, 60))
        print(f"Sampled Background Color from {GOOD_CARD} top-center: {bg_color}")

    # 2. Process Bad Cards
    margin = 15 # The size of the gold border we added
    
    for card_name in BAD_CARDS:
        card_path = os.path.join(BASE_PATH, card_name)
        if not os.path.exists(card_path):
            continue
            
        print(f"Repairing {card_name}...")
        try:
            with Image.open(card_path) as img:
                img = img.convert("RGBA")
                w, h = img.size
                
                # Draw a rectangle of BG Color over the whole image? No.
                # We want to replace the Gold Border with the BG Color.
                # The Gold border is exactly margin pixels wide.
                # Actually, simpler: just create a new BG-Color image, paste the CENTER of the current image over it.
                # The CENTER (inner part) is the good part (Dark Blue + Icon).
                # The OUTER part is Gold.
                
                inner_w = w - 2 * margin
                inner_h = h - 2 * margin
                
                # Crop out the inner part (ignoring the gold frame)
                # Box: (15, 15, w-15, h-15)
                content = img.crop((margin, margin, w - margin, h - margin))
                
                # Verify content size
                # 440 - 30 = 410.
                
                # Create New Image with Correct Blue
                new_img = Image.new("RGBA", (w, h), bg_color)
                
                # Paste the inner content back in the center
                # This essentially "erases" the Gold border and replaces it with Blue.
                # AND it preserves the crop we did in the first step (which removed the white artifacts).
                # Note: We are not cropping AGAIN. We are just grabbing the valid region we established in step 1.
                # Wait, step 1 created the Gold border by pasting cropped content into Gold canvas.
                # So the content is AT (15, 15).
                # So cropping (15, 15, ...) retrieves exactly the content we wanted to save.
                
                new_img.paste(content, (margin, margin))
                
                new_img.save(card_path)
                print(f" -> Repaired {card_name}")
                
        except Exception as e:
            print(f"Error repairing {card_name}: {e}")

if __name__ == "__main__":
    fix_gold_borders()
