# KRA.sk + Stream Cinema API Research

**Updated:** 2026-02-06 14:22

---

## Přehled Systému

```
┌─────────────┐     ┌──────────────────┐     ┌─────────────┐
│   KRA.sk    │────▶│  Stream Cinema   │────▶│   Klient    │
│  (storage)  │     │    (backend)     │     │   (addon)   │
└─────────────┘     └──────────────────┘     └─────────────┘
```

**Role:**
- **KRA.sk** - cloud storage, hostuje soubory, resolvuje ident → URL
- **Stream Cinema** - agregátor metadat, vyhledávání filmů/seriálů
- **Klient** - autentizace přes oba, vyhledávání přes SC, přehrávání přes KRA.sk

---

## Autentizační Flow

```
┌─────────────────────────────────────────────────────────────┐
│  1. KRA.sk Login                                            │
│     POST https://api.kra.sk/api/user/login                  │
│     Body: { "data": { "username": "...", "password": "..." }}│
│     Response: { "session_id": "PmOAavyfQ9TC" }              │
└─────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────┐
│  2. Stream Cinema Auth                                      │
│     POST https://stream-cinema.online/kodi/auth/token       │
│     Params: krt=PmOAavyfQ9TC                                │
│     Response: { "token": "f94c65dded9f1034ea1734eb9f050fea" }│
└─────────────────────────────────────────────────────────────┘
```

---

## Stream Cinema API

**Base URL:** `https://stream-cinema.online/kodi`

### Povinné Query Parametry

Každý request MUSÍ obsahovat:

| Parametr | Hodnota | Popis |
|----------|---------|-------|
| `ver` | `2.0` | API verze |
| `uid` | UUID | Unikátní ID instalace |
| `skin` | `milionar` | Název skinu/addonu |
| `lang` | `CS` | Jazyk |
| `HDR` | `1` | HDR podpora |
| `DV` | `0` | Dolby Vision |

### Povinné Headers

| Header | Hodnota |
|--------|---------|
| `User-Agent` | `Milionar/1.0 (Kodi)` |
| `X-AUTH-TOKEN` | SC auth token |
| `X-Uuid` | UUID instalace |

---

### Vyhledávání

#### Filmy

```http
GET /Search/search-movies?search=Terminator&ms=1&typ=1&ver=2.0&...
```

#### Seriály

```http
GET /Search/search-series?search=How%20I%20Met%20Your%20Mother&ms=1&typ=2&ver=2.0&...
```

> **KRITICKÉ:** Parametr `typ` určuje databázi:
> - `typ=1` - filmy (výchozí)
> - `typ=2` - **seriály**
> 
> Bez `typ=2` endpoint `search-series` hledá ve filmové databázi!

#### Response

```json
{
  "menu": [
    {
      "type": "video",
      "id": "3824",
      "url": "/Play/m_9vvyitDyZVq2",
      "info": {
        "year": 2007,
        "episode": 5,
        "season": 3,
        "rating": 8.4,
        "tvshowtitle": "How I Met Your Mother"
      }
    }
  ],
  "filter": { ... },
  "system": { ... }
}
```

---

### Získání Streamů

```http
GET /Play/m_9vvyitDyZVq2?ver=2.0&...
Headers: X-AUTH-TOKEN: ...
```

#### Response

```json
{
  "strms": [
    {
      "provider": "kraska",
      "url": "/Provider/kraska/...",
      "quality": "1080p",
      "lang": "CZ",
      "bitrate": "8500",
      "size": "4.91 GB",
      "ainfo": "AC3 5.1",
      "vinfo": "x265 HEVC",
      "stream_info": {
        "size": 4294967296
      }
    }
  ]
}
```

> **Pozor:** `bitrate` přichází jako **string**, ne int!

---

### Získání Ident

```http
GET /Provider/kraska/...?ver=2.0&...
Headers: X-AUTH-TOKEN: ...
```

#### Response

```json
{
  "ident": "eNJebgA5JMoU"
}
```

---

## KRA.sk API

**Base URL:** `https://api.kra.sk`

### Login

```http
POST /api/user/login
Content-Type: application/json

{
  "data": {
    "username": "email@example.com",
    "password": "heslo"
  }
}
```

#### Response

```json
{
  "session_id": "PmOAavyfQ9TC"
}
```

---

### Resolve Ident → URL

```http
POST /api/file/download
Content-Type: application/json

{
  "data": {
    "ident": "eNJebgA5JMoU"
  },
  "session_id": "PmOAavyfQ9TC"
}
```

#### Response

```json
{
  "data": {
    "link": "https://cdn.kra.sk/download/video.mp4?token=..."
  }
}
```

---

## Kompletní Flow: Přehrání Seriálu

```
1. Uživatel vybere S01E01 seriálu "HIMYM"
                    │
                    ▼
2. SC API: GET /Search/search-series?search=HIMYM&typ=2
   Response: menu[0].url = "/Play/m_9vvyitDyZVq2"
                    │
                    ▼
3. SC API: GET /Play/m_9vvyitDyZVq2
   Response: strms[0] = { provider: "kraska", url: "/Provider/kraska/..." }
                    │
                    ▼
4. SC API: GET /Provider/kraska/...
   Response: { ident: "eNJebgA5JMoU" }
                    │
                    ▼
5. KRA.sk: POST /api/file/download { ident: "eNJebgA5JMoU" }
   Response: { link: "https://cdn.kra.sk/..." }
                    │
                    ▼
6. Přehrání URL v Kodi
```

---

## Omezení

1. **KRA.sk nemá veřejné vyhledávání** - endpoint `/api/file/list` je pouze pro vlastní soubory
2. **Stream Cinema je nutný** pro vyhledávání ve veřejně dostupném obsahu
3. **Parametr `typ` je kritický** - bez něj seriály nenajde
