# Webshare Provider

**Status:** COMPLETED  
**Vytvořeno:** 2026-02-06  
**Updated:** 2026-02-06 14:29

---

## Související dokumenty

- [001-kraska-provider.md](001-kraska-provider.md) - KRA.sk provider
- [003-multi-provider.md](003-multi-provider.md) - Multi-provider nastavení

---

## Účel

Webshare.cz je primární provider pro streamování video souborů. Na rozdíl od KRA.sk má **vlastní vyhledávací API** s fulltextovým vyhledáváním ve veřejně sdílených souborech.

---

## Nastavení

| Klíč | Typ | Popis |
|------|-----|-------|
| `webshare_enabled` | bool | Zapnutí Webshare provideru |
| `webshare_user` | string | Uživatelské jméno/email |
| `webshare_password` | string | Heslo |
| `token` | string | Webshare session token (wst) |

**Zapnutí:** Nastavení → Providery → Webshare

---

## Autentizační Flow

```
┌─────────────────────────────────────────────────────────────┐
│  1. Získání salt                                            │
│     POST https://webshare.cz/api/salt                       │
│     Body: username_or_email={email}                         │
│     → salt (pro hashování hesla)                            │
└─────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────┐
│  2. Hashování hesla                                         │
│     encrypted = SHA1(md5crypt(password, salt))              │
│     digest = MD5(username + ":Webshare:" + encrypted)       │
└─────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────┐
│  3. Login                                                   │
│     POST https://webshare.cz/api/login                      │
│     Body: username, password (encrypted), digest            │
│     → token (wst)                                           │
└─────────────────────────────────────────────────────────────┘
```

**Implementace:** `wcs/webshare/WebshareClient.py` funkce `login()`

---

## Kompletní Flow: Přehrání Filmu

```
1. Uživatel spustí film "Terminator 3"
                    │
                    ▼
2. Webshare API: POST /api/search
   Body: what=Terminator+3, category=video, limit=50, wst={token}
   → XML s file elementy
                    │
                    ▼
3. Parsování XML
   Pro každý <file>: ident, name, size, positive_votes, negative_votes
                    │
                    ▼
4. Řazení: sort_files_by_priority()
   → Seřazeno podle kvality, velikosti, jazyka
                    │
                    ▼
5. Výběr nebo autoplay prvního souboru
   → ident = "abc123def456"
                    │
                    ▼
6. Webshare API: POST /api/file_link
   Body: ident, wst, download_type=video_stream
   → link = "https://cdn.webshare.cz/video.mp4"
                    │
                    ▼
7. Přehrání URL v Kodi
```

**Implementace:** `wcs/ui/dialogs/DialogWcsSearch.py` funkce `_perform_search_webshare()`

---

## Kompletní Flow: Přehrání Seriálu

```
1. Uživatel spustí S01E01 seriálu "HIMYM"
                    │
                    ▼
2. Webshare API: POST /api/search
   Body: what=HIMYM+S01E01, category=video, limit=50
   
   Retry logika (pokud málo výsledků):
   - Query 1: "HIMYM S01E01"
   - Query 2: "HIMYM S01E01" (opakování pro stabilitu)
   - Query 3: "HIMYM S1E1" (alternativní formát)
                    │
                    ▼
3-7. Stejné jako u filmu, ale s řazením sort_series_files_by_priority()
```

**Implementace:** `wcs/search/SeriesSearch.py` funkce `_search_via_webshare()` a `do_webshare_search_with_retry()`

---

## Metadata a Display Names

### Struktura souboru z Webshare API

```xml
<file>
  <ident>abc123def456</ident>
  <name>Terminator.3.2003.1080p.BluRay.CZ.x264.mkv</name>
  <size>8589934592</size>
  <positive_votes>42</positive_votes>
  <negative_votes>2</negative_votes>
</file>
```

### Extrakce metadat z názvu

Webshare **nevrací strukturovaná metadata** - vše se extrahuje z názvu souboru:

| Funkce | Příklad | Výsledek |
|--------|---------|----------|
| `extract_quality()` | "Film.1080p.mkv" | "1080p" |
| `extract_language()` | "Film.CZ.mkv" | "CZ" |
| `extract_format()` | "Film.mkv" | "MKV" |
| `extract_clean_title()` | "Film.2023.1080p.mkv" | "Film" |

**Implementace:** `wcs/utils.py`

---

## Řazení Výsledků

Používá se `calculate_advanced_score()` z `wcs/utils.py`.

### Priorita řazení

| Pořadí | Kritérium | Body |
|--------|-----------|------|
| 1 | Kvalita videa | 0-50000 |
| 2 | Velikost souboru | 0-3000 |
| 3 | CZ jazyk | 0-500 |
| 4 | Bonusy (HDR, HEVC) | 0-200 |

### Skóre kvality z názvu

| Pattern | Body |
|---------|------|
| REMUX (15GB+) | 50000 |
| 4K/2160p/UHD | 40000 |
| 1080p | 30000 |
| HD | 20000 |
| 720p | 15000 |
| 480p | 10000 |
| 360p | 5000 |

### Rozdíl: Filmy vs Seriály

| Aspekt | Filmy | Seriály |
|--------|-------|---------|
| Řadící funkce | `sort_files_by_priority()` | `sort_series_files_by_priority()` |
| Filtrování seriálů | Ano (`filter_series=True`) | Ne |
| Retry logika | Ne | Ano (3 pokusy s různými formáty) |

---

## Klíčové Soubory

| Soubor | Účel |
|--------|------|
| `wcs/webshare/WebshareClient.py` | Webshare API (login, search, file_link) |
| `wcs/login/DialogWebshareLogin.py` | Login dialog pro Webshare |
| `wcs/search/SeriesSearch.py` | Vyhledávání seriálů (`_search_via_webshare`) |
| `wcs/ui/dialogs/DialogWcsSearch.py` | Vyhledávání filmů (`_perform_search_webshare`) |
| `wcs/utils.py` | Extrakce metadat a řazení |
| `wcs/router.py` | Playback routing |

---

## API Reference

### Webshare (`https://webshare.cz/api`)

| Endpoint | Metoda | Účel |
|----------|--------|------|
| `/salt` | POST | Získání salt pro hashování hesla |
| `/login` | POST | Login → token (wst) |
| `/user_data` | POST | Info o účtu, VIP stav |
| `/search` | POST | Fulltextové vyhledávání |
| `/file_link` | POST | Resolve ident → stream URL |

### Parametry vyhledávání

| Parametr | Hodnota | Popis |
|----------|---------|-------|
| `what` | string | Hledaný text |
| `category` | "video" | Pouze video soubory |
| `sort` | "" | Výchozí řazení |
| `limit` | 50 | Max počet výsledků |
| `offset` | 0 | Stránkování |
| `wst` | token | Session token |

---

## VIP Stav

Webshare rozlišuje VIP a non-VIP uživatele:
- **VIP:** Plná rychlost stahování
- **Non-VIP:** Omezená rychlost

**Kontrola:** `refresh_vip_info()` v `WebshareClient.py`
