---
description: Generování obrázku pro Kodi addon — ikony, pozadí, fanart, bannery
---

# /image

Syntaxe: viz `workflow-syntax.md` — scope: typ obrázku, `/do` = vygeneruje bez ptaní

Použij skill `kodi-image-generator`.

## Postup

### 1. Zjisti požadavky (bez `/do`)
- A) Ikona addonu (256x256, PNG)
- B) Fanart/pozadí (1920x1080, JPG)
- C) Banner (758x140, PNG)
- D) UI grafika (tlačítka, dekorace)
- E) Vlastní specifikace

### 2. Upřesni detaily
- Rozměry a formát
- Téma/styl (konzistentní s addonem)
- Obsah a kompozice

### 3. Generuj obrázek
```
generate_image(Prompt="...", ImageName="...")
```

### 4. Čekej na schválení (bez `/do`)

### 5. Post-processing (po schválení)
- Resize na cílové rozměry (PIL/Pillow)
- Uložení do `resources/media/` nebo kořenové složky addonu

## Pravidla
- Žádné WebP (omezená podpora v Kodi)
- Ikony musí být čitelné v malé velikosti
- Fanart nesmí obsahovat text (bude překryt UI)
- Transparence pouze PNG

## Cesty v addonu
```
resources/
├── icon.png      # Hlavní ikona 256x256
├── fanart.jpg    # Pozadí 1920x1080
└── media/        # Další grafika
```
