---
name: Image Generator
description: Generování obrázků pro Kodi addon — ikony, pozadí, bannery
trigger: generate_image, obrázek, ikona, pozadí, fanart, banner, grafika
---

# Kodi Image Generator

Generování grafiky pro Kodi addon pomocí AI.

## Kdy použít
- Addon ikona (`icon.png`)
- Pozadí addonu (`fanart.jpg`)
- Bannery a dekorativní grafika
- Obrázky do UI

## Rozlišení
| Typ | Rozměr | Formát |
|-----|--------|--------|
| Ikona | 256x256 nebo 512x512 | PNG |
| Fanart | 1920x1080 | JPG |
| Banner | 758x140 | PNG |
| Poster | 1000x1500 | JPG |

## Workflow

### 1. Zjisti požadavky
- Typ grafiky (ikona/fanart/banner)
- Téma/styl addonu
- Barevná paleta

### 2. Generuj
```
generate_image(Prompt, ImageName)
```

### 3. Post-processing (pokud potřeba)
```python
from PIL import Image
img = Image.open("source.png")
img = img.resize((256, 256), Image.LANCZOS)
img.save("icon.png", "PNG")
```

## Cesty v addonu
```
resources/
├── icon.png      # Hlavní ikona 256x256
├── fanart.jpg    # Pozadí 1920x1080
└── media/        # Další grafika
    ├── banner.png
    └── ...
```

## Pravidla
- Žádné WebP (omezená podpora v Kodi)
- Ikony musí být čitelné i v malé velikosti
- Fanart nesmí obsahovat text (bude překryt UI)
- Transparence pouze PNG
