// swift-tools-version: 6.2
import PackageDescription

let package = Package(
    name: "StreamCinemaNative",
    platforms: [
        .macOS(.v15)
    ],
    products: [
        .library(
            name: "StreamCinemaCore",
            targets: ["StreamCinemaCore"]
        ),
        .executable(
            name: "sc-cli",
            targets: ["StreamCinemaCLI"]
        ),
        .executable(
            name: "sc-desktop",
            targets: ["StreamCinemaDesktop"]
        )
    ],
    dependencies: [
        .package(url: "https://github.com/tylerjonesio/vlckit-spm.git", from: "3.6.0")
    ],
    targets: [
        .target(
            name: "StreamCinemaCore"
        ),
        .executableTarget(
            name: "StreamCinemaCLI",
            dependencies: ["StreamCinemaCore"]
        ),
        .executableTarget(
            name: "StreamCinemaDesktop",
            dependencies: [
                "StreamCinemaCore",
                .product(name: "VLCKitSPM", package: "vlckit-spm")
            ]
        )
    ]
)
