#!/usr/bin/env python3
"""Generate gradient fade bottom with rounded corners texture for Kodi dialog."""
from PIL import Image, ImageDraw

# Dimensions (will be scaled down for antialiasing)
WIDTH = 820
HEIGHT = 350
RADIUS = 40
SCALE = 2

# Create at higher resolution for antialiasing
w, h = WIDTH * SCALE, HEIGHT * SCALE
r = RADIUS * SCALE

# Create transparent image
img = Image.new('RGBA', (w, h), (0, 0, 0, 0))
draw = ImageDraw.Draw(img)

# Draw rounded rectangle mask (only top corners rounded)
# Top-left and top-right rounded, bottom-left and bottom-right square
draw.rounded_rectangle(
    [(0, 0), (w - 1, h - 1)],
    radius=r,
    fill=(255, 255, 255, 255)
)

# Now apply vertical gradient to alpha channel (fade at bottom)
# Top = full opacity, bottom = transparent
for y in range(h):
    # Linear gradient: full at top, fade starts at 50%
    if y < h * 0.5:
        alpha = 255
    else:
        # Fade from 100% to 0% opacity
        progress = (y - h * 0.5) / (h * 0.5)
        alpha = int(255 * (1 - progress))
    
    for x in range(w):
        r, g, b, a = img.getpixel((x, y))
        if a > 0:  # Only modify visible pixels
            new_alpha = min(a, alpha)
            img.putpixel((x, y), (r, g, b, new_alpha))

# Downscale for antialiasing
img = img.resize((WIDTH, HEIGHT), Image.LANCZOS)

# Save
output_path = '/Users/chudy/Library/Application Support/Kodi/addons/plugin.video.milionar/resources/media/gradient_fade_bottom_rounded.png'
img.save(output_path, 'PNG')
print(f"Created: {output_path}")
