# KRA.sk Provider

**Status:** COMPLETED  
**Vytvořeno:** 2026-02-06  
**Updated:** 2026-02-06 14:29

---

## Související dokumenty

- [002-webshare-provider.md](002-webshare-provider.md) - Webshare provider
- [003-multi-provider.md](003-multi-provider.md) - Multi-provider nastavení

---

## Účel

KRA.sk provider umožňuje streamování video souborů z KRA.sk úložiště jako alternativu k Webshare.cz. Na rozdíl od Webshare **nemá vlastní vyhledávací API** - vyhledávání probíhá přes **Stream Cinema backend**.

---

## Nastavení

| Klíč | Typ | Popis |
|------|-----|-------|
| `kraska_enabled` | bool | Zapnutí KRA.sk provideru |
| `kraska_token` | string | KRA.sk session ID |
| `sc_auth_token` | string | Stream Cinema auth token |

**Zapnutí:** Nastavení → Providery → KRA.sk

---

## Autentizační Flow

```
┌─────────────────────────────────────────────────────────────┐
│  1. KRA.sk Login                                            │
│     POST https://api.kra.sk/api/user/login                  │
│     Body: { "data": { "username": "...", "password": "..." }}│
│     → session_id                                            │
└─────────────────────────────────────────────────────────────┘
                           │
                           ▼
┌─────────────────────────────────────────────────────────────┐
│  2. Stream Cinema Auth                                      │
│     POST https://stream-cinema.online/kodi/auth/token       │
│     Params: krt={session_id}                                │
│     → sc_auth_token                                         │
└─────────────────────────────────────────────────────────────┘
```

**Implementace:** `wcs/login/DialogKraskaLogin.py`, `wcs/kraska/KraskaClient.py`

---

## Kompletní Flow: Přehrání Filmu

```
1. Uživatel spustí film "Terminator 3"
                    │
                    ▼
2. SC API: GET /Search/search-movies?search=Terminator+3&typ=1
   Headers: X-AUTH-TOKEN: {sc_auth_token}
   → menu[0].url = "/Play/m_abc123"
                    │
                    ▼
3. SC API: GET /Play/m_abc123
   → strms[] = seznam streamů
                    │
                    ▼
4. Filtrování: provider == "kraska"
   → stream.url = "/Provider/kraska/xyz789"
                    │
                    ▼
5. SC API: GET /Provider/kraska/xyz789
   → { ident: "eNJebgA5JMoU" }
                    │
                    ▼
6. KRA.sk: POST /api/file/download
   Body: { ident: "...", session_id: "..." }
   → { link: "https://cdn.kra.sk/video.mp4" }
                    │
                    ▼
7. Přehrání URL v Kodi
```

**Implementace:** `wcs/streamcinema/SCClient.py`, `wcs/kraska/KraskaClient.py`

---

## Kompletní Flow: Přehrání Seriálu

```
1. Uživatel spustí S01E01 seriálu "HIMYM"
                    │
                    ▼
2. SC API: GET /Search/search-series?search=HIMYM&typ=2
   ⚠️ KRITICKÉ: typ=2 pro seriály!
   → menu[0].url = "/Play/m_xyz789"
                    │
                    ▼
3-7. Stejné jako u filmu
```

> **Pozor:** Bez parametru `typ=2` endpoint `search-series` hledá ve filmové databázi a nevrátí žádné výsledky!

**Implementace:** `wcs/search/SeriesSearch.py` funkce `_search_via_kraska()`

---

## Metadata a Display Names

### Struktura streamu z SC API

```json
{
  "provider": "kraska",
  "url": "/Provider/kraska/...",
  "quality": "1080p",
  "lang": "CZ",
  "bitrate": "8500",
  "size": "4.91 GB"
}
```

> **Pozor:** `bitrate` a `size` přicházejí jako **stringy**, nutná konverze na int!

### Syntetický název

Protože originální názvy souborů z SC API jsou často nečitelné interní kódy, vytváříme **syntetický název** pro zobrazení a řazení:

**Filmy:**
```
{movie_title}.{quality}.{lang}.mkv
→ "Terminator 3.1080p.CZ.mkv"
```

**Seriály:**
```
{series_name}.S{season:02d}E{episode:02d}.{quality}.{lang}.mkv
→ "Jak jsem poznal vaši matku.S01E01.4K.CZ.mkv"
```

### Odhad kvality z bitrate

Pokud `quality` není dostupná, odhaduje se z `bitrate`:

| Bitrate (kbps) | Kvalita |
|----------------|---------|
| ≥ 20000 | 4K |
| ≥ 8000 | 1080p |
| ≥ 4000 | 720p |
| ≥ 2000 | 480p |
| < 2000 | SD |

---

## Řazení Výsledků

Používá se **stejná funkce** jako pro Webshare: `calculate_advanced_score()` z `wcs/utils.py`.

### Priorita řazení

| Pořadí | Kritérium | Body |
|--------|-----------|------|
| 1 | Kvalita videa | 0-50000 |
| 2 | Velikost souboru | 0-3000 |
| 3 | CZ jazyk | 0-500 |
| 4 | Bonusy (HDR, HEVC) | 0-200 |

### Rozdíl oproti Webshare

| Aspekt | Webshare | KRA.sk |
|--------|----------|--------|
| Kvalita v názvu | Ano (extrahuje se z filename) | Ne (synteticky přidává se) |
| Jazyk v názvu | Ano (extrahuje se z filename) | Ne (synteticky přidává se) |
| Metadata | V XML odpovědi | V JSON stream objektu |

---

## Klíčové Soubory

| Soubor | Účel |
|--------|------|
| `wcs/kraska/KraskaClient.py` | KRA.sk API (login, resolve ident) |
| `wcs/streamcinema/SCClient.py` | Stream Cinema API (auth, search, streams) |
| `wcs/login/DialogKraskaLogin.py` | Login dialog pro KRA.sk |
| `wcs/search/SeriesSearch.py` | Vyhledávání seriálů (`_search_via_kraska`) |
| `wcs/ui/dialogs/DialogWcsSearch.py` | Vyhledávání filmů (KRA.sk sekce) |
| `wcs/router.py` | Playback routing pro KRA.sk |

---

## API Reference

### KRA.sk (`https://api.kra.sk`)

| Endpoint | Metoda | Účel |
|----------|--------|------|
| `/api/user/login` | POST | Login → session_id |
| `/api/user/info` | POST | Info o účtu |
| `/api/file/download` | POST | Resolve ident → stream URL |

### Stream Cinema (`https://stream-cinema.online/kodi`)

| Endpoint | Metoda | Účel |
|----------|--------|------|
| `/auth/token?krt=...` | POST | Session → SC token |
| `/Search/search-movies?typ=1` | GET | Hledání filmů |
| `/Search/search-series?typ=2` | GET | Hledání seriálů |
| `/{playPath}` | GET | Seznam streamů |
| `/{providerPath}` | GET | Získání ident |

**Povinné query parametry:** `ver`, `uid`, `skin`, `lang`, `HDR`, `DV`
