---
description: Debug session - přidá logy do Python kódu pro sledování v Kodi logu
---

# /debug

Syntaxe: `/debug [komponenta/popis problému]`

Agent přidává diagnostické logy, NESPOUŠTÍ Kodi.

## Zdroj problému
- Primárně: aktuální dialog
- Sekundárně: `docs/issues/*.md`

## Kroky

### 1. Identifikuj místa pro logy
- Které Python soubory jsou relevantní
- Které funkce sledovat
- Jaké hodnoty logovat

### 2. Přidej diagnostické logy
```python
# 🔍 DEBUG: [popis]
import xbmc
xbmc.log('🔍 [Component] [function]: [message]', xbmc.LOGINFO)
xbmc.log(f'🔍 [Component] state: {variable}', xbmc.LOGINFO)
```

Pravidla:
- Emoji 🔍 pro filtrování
- Název komponenty a funkce
- Loguj vstupy/výstupy funkcí
- Používej `xbmc.LOGINFO` pro debug

### 3. Instrukce pro uživatele
```
📋 Debug session připravena!
1. Restartuj Kodi
2. Reprodukuj problém
3. Otevři kodi.log:
   - macOS: ~/Library/Logs/kodi.log
   - Windows: %APPDATA%\Kodi\kodi.log
   - Linux: ~/.kodi/temp/kodi.log
4. Filtruj: "🔍"
5. Pošli relevantní část logu
```

### 4. Čekej na feedback

### 5. Po opravě ČEKEJ na potvrzení
NIKDY automaticky neodstraňuj logy.

### 6. Cleanup (po potvrzení)
Odstraň řádky obsahující "🔍 DEBUG"
