---
trigger: when any workflow is invoked with parameters or combined with other workflows
---

# Workflow Syntax System

## Syntaxe
```
/[workflow] [scope] [/modifikátor]
```

### Scope (volitelný)
Agent automaticky najde relevantní soubory.
- Prázdný = celý projekt
- Název komponenty: `ai-chat`, `game-milionar`, `tmdb-browser`
- Slovní popis: `dialog pro přidání média`
- Technologie: `Python`, `XML`, `skin`

Rozpoznání kontextu:
- `/learn vyjížděcí okno` → agent vyhledá relevantní soubory
- Nejasné bez `/do` → zeptá se
- Nejasné s `/do` → vybere nejpravděpodobnější

### Modifikátory
- `/do` = provede bez čekání
- `/explain` = vysvětlí plán před provedením
- Jiný workflow = kombinace

## Kombinace příkazů
- `/learn /do` = prozkoumá + report bez ptaní
- `/analyze /do` = analýza + implementace
- `/audit /fix` = audit + oprava všech nálezů
- `/fix X /do` = oprav X + proveď bez ptaní

## Chování při nejasnostech

BEZ `/do`:
Agent najde více možností → zeptá se → čeká na odpověď

S `/do`:
Agent najde více možností → vybere nejpravděpodobnější → provede

## Příklady
```
/learn                     # celý projekt, čeká
/learn wheel-picker        # komponenta
/audit CSS                 # jen CSS
/fix detail tréninku       # slovní popis
/learn /do                 # prozkoumá + report
/audit CSS /fix            # audit + oprava
```
