---
trigger: model_decision
description: Pravidla pro debugování Kodi addonu - analýza logů a dočasné debug výpisy
---

## Kodi Log - macOS

**Cesta k logu:**
```
/Users/chudy/Library/Logs/kodi.log
```

---

## Postup při debugování

### 1. Analýza chyby
- Přečti posledních 100-200 řádků logu
- Hledej `ERROR`, `WARNING` nebo traceback pro `plugin.video.milionar`
- Identifikuj přesnou příčinu chyby

### 2. Dočasné debug logy
Pokud potřebuješ více informací, přidej debug výpisy:

```python
import xbmc
xbmc.log(f"[DEBUG] popis: {promenna}", xbmc.LOGINFO)
```

**Pravidla pro debug logy:**
- Prefix `[DEBUG]` pro snadné vyhledání
- Popisné zprávy co se měří/kontroluje
- Loguj pouze relevantní proměnné

### 3. Úklid po vyřešení
> **POVINNÉ** - Po opravě chyby VŽDY odstraň všechny dočasné debug logy které jsi přidal.

- Vyhledej `[DEBUG]` v upravených souborech
- Smaž všechny řádky s dočasnými logy
- Ponech pouze permanentní logy které jsou součástí produkčního kódu

---

## Existující logging v projektu

Před přidáváním vlastních logů zkontroluj existující logging infrastrukturu v projektu a používej ji pokud existuje.
