---
description: Kompletní vymazání cache a hard reload Safari + bump verze CSS
---

# /reload-safari

Kompletní workflow pro vymazání cache a načtení čerstvé verze webu.

## Kdy použít
- Po úpravě CSS/HTML/JS
- Když stránka nenačítá nové změny
- Při 404 na nové soubory

## Kroky

### 1. Bump CSS verze
```bash
sed -i '' 's/styles\\.css?v=[0-9]*/styles.css?v='$(date +%s)'/' index.html
```

### 2. Empty Caches + Hard Reload
```bash
osascript -e 'tell application "Safari" to activate' -e 'delay 0.2' -e 'tell application "System Events"' -e 'keystroke "e" using {option down, command down}' -e 'delay 0.3' -e 'keystroke "r" using {option down, command down}' -e 'end tell'
```

## Co to dělá
1. Bump verze = přepíše `styles.css?v=XX` na aktuální timestamp
2. Cmd+Option+E = Empty Caches
3. Cmd+Option+R = Hard Reload

Funguje pouze na macOS s otevřeným Safari.
